/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.PatchAccountExternalDto;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsResponse;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountResponse;
import com.stackone.stackone_client_java.operations.StackoneDeleteAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccount;
import com.stackone.stackone_client_java.operations.StackoneGetAccountMetaInfo;
import com.stackone.stackone_client_java.operations.StackoneListLinkedAccounts;
import com.stackone.stackone_client_java.operations.StackoneUpdateAccount;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;

/**
 * Chart of accounts.
 */
public class Accounts {
    private final SDKConfiguration sdkConfiguration;
    private final AsyncAccounts asyncSDK;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncAccounts(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncAccounts async() {
        return asyncSDK;
    }

    /**
     * List Accounts
     * 
     * @return The call builder
     */
    public StackoneListLinkedAccountsRequestBuilder listLinkedAccounts() {
        return new StackoneListLinkedAccountsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneListLinkedAccountsResponse listLinkedAccounts(StackoneListLinkedAccountsRequest request) throws Exception {
        return listLinkedAccounts(request, Optional.empty());
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneListLinkedAccountsResponse listLinkedAccounts(StackoneListLinkedAccountsRequest request, Optional<Options> options) throws Exception {
        RequestOperation<StackoneListLinkedAccountsRequest, StackoneListLinkedAccountsResponse> operation
              = new StackoneListLinkedAccounts.Sync(sdkConfiguration, options);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Account
     * 
     * @return The call builder
     */
    public StackoneGetAccountRequestBuilder getAccount() {
        return new StackoneGetAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Account
     * 
     * @param id 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountResponse getAccount(String id) throws Exception {
        return getAccount(id, Optional.empty());
    }

    /**
     * Get Account
     * 
     * @param id 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountResponse getAccount(String id, Optional<Options> options) throws Exception {
        StackoneGetAccountRequest request =
            StackoneGetAccountRequest
                .builder()
                .id(id)
                .build();
        RequestOperation<StackoneGetAccountRequest, StackoneGetAccountResponse> operation
              = new StackoneGetAccount.Sync(sdkConfiguration, options);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Delete Account
     * 
     * @return The call builder
     */
    public StackoneDeleteAccountRequestBuilder deleteAccount() {
        return new StackoneDeleteAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete Account
     * 
     * @param id 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneDeleteAccountResponse deleteAccount(String id) throws Exception {
        return deleteAccount(id, Optional.empty());
    }

    /**
     * Delete Account
     * 
     * @param id 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneDeleteAccountResponse deleteAccount(String id, Optional<Options> options) throws Exception {
        StackoneDeleteAccountRequest request =
            StackoneDeleteAccountRequest
                .builder()
                .id(id)
                .build();
        RequestOperation<StackoneDeleteAccountRequest, StackoneDeleteAccountResponse> operation
              = new StackoneDeleteAccount.Sync(sdkConfiguration, options);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update Account
     * 
     * @return The call builder
     */
    public StackoneUpdateAccountRequestBuilder updateAccount() {
        return new StackoneUpdateAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Update Account
     * 
     * @param id 
     * @param patchAccountExternalDto 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneUpdateAccountResponse updateAccount(String id, PatchAccountExternalDto patchAccountExternalDto) throws Exception {
        return updateAccount(id, patchAccountExternalDto, Optional.empty());
    }

    /**
     * Update Account
     * 
     * @param id 
     * @param patchAccountExternalDto 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneUpdateAccountResponse updateAccount(
            String id, PatchAccountExternalDto patchAccountExternalDto,
            Optional<Options> options) throws Exception {
        StackoneUpdateAccountRequest request =
            StackoneUpdateAccountRequest
                .builder()
                .id(id)
                .patchAccountExternalDto(patchAccountExternalDto)
                .build();
        RequestOperation<StackoneUpdateAccountRequest, StackoneUpdateAccountResponse> operation
              = new StackoneUpdateAccount.Sync(sdkConfiguration, options);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Account Meta Information
     * 
     * @return The call builder
     */
    public StackoneGetAccountMetaInfoRequestBuilder getAccountMetaInfo() {
        return new StackoneGetAccountMetaInfoRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Account Meta Information
     * 
     * @param id 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(String id) throws Exception {
        return getAccountMetaInfo(id, Optional.empty());
    }

    /**
     * Get Account Meta Information
     * 
     * @param id 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(String id, Optional<Options> options) throws Exception {
        StackoneGetAccountMetaInfoRequest request =
            StackoneGetAccountMetaInfoRequest
                .builder()
                .id(id)
                .build();
        RequestOperation<StackoneGetAccountMetaInfoRequest, StackoneGetAccountMetaInfoResponse> operation
              = new StackoneGetAccountMetaInfo.Sync(sdkConfiguration, options);
        return operation.handleResponse(operation.doRequest(request));
    }

}
