/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class ActionsRpcRequestDto {
    /**
     * The action to execute
     */
    @JsonProperty("action")
    private String action;

    /**
     * Input parameters for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("input")
    private JsonNullable<? extends Input> input;

    @JsonCreator
    public ActionsRpcRequestDto(
            @JsonProperty("action") String action,
            @JsonProperty("input") JsonNullable<? extends Input> input) {
        Utils.checkNotNull(action, "action");
        Utils.checkNotNull(input, "input");
        this.action = action;
        this.input = input;
    }
    
    public ActionsRpcRequestDto(
            String action) {
        this(action, JsonNullable.undefined());
    }

    /**
     * The action to execute
     */
    @JsonIgnore
    public String action() {
        return action;
    }

    /**
     * Input parameters for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Input> input() {
        return (JsonNullable<Input>) input;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The action to execute
     */
    public ActionsRpcRequestDto withAction(String action) {
        Utils.checkNotNull(action, "action");
        this.action = action;
        return this;
    }

    /**
     * Input parameters for the action
     */
    public ActionsRpcRequestDto withInput(Input input) {
        Utils.checkNotNull(input, "input");
        this.input = JsonNullable.of(input);
        return this;
    }

    /**
     * Input parameters for the action
     */
    public ActionsRpcRequestDto withInput(JsonNullable<? extends Input> input) {
        Utils.checkNotNull(input, "input");
        this.input = input;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionsRpcRequestDto other = (ActionsRpcRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.action, other.action) &&
            Utils.enhancedDeepEquals(this.input, other.input);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            action, input);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionsRpcRequestDto.class,
                "action", action,
                "input", input);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String action;

        private JsonNullable<? extends Input> input = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The action to execute
         */
        public Builder action(String action) {
            Utils.checkNotNull(action, "action");
            this.action = action;
            return this;
        }


        /**
         * Input parameters for the action
         */
        public Builder input(Input input) {
            Utils.checkNotNull(input, "input");
            this.input = JsonNullable.of(input);
            return this;
        }

        /**
         * Input parameters for the action
         */
        public Builder input(JsonNullable<? extends Input> input) {
            Utils.checkNotNull(input, "input");
            this.input = input;
            return this;
        }

        public ActionsRpcRequestDto build() {

            return new ActionsRpcRequestDto(
                action, input);
        }

    }
}
