/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;


public class DocumentsListFilesRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * The session token
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-stackone-api-session-token")
    private Optional<String> xStackoneApiSessionToken;

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=raw")
    private JsonNullable<Boolean> raw;

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=proxy")
    private JsonNullable<? extends Map<String, Object>> proxy;

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=fields")
    private JsonNullable<String> fields;

    /**
     * Documents Files Filter
     */
    @SpeakeasyMetadata("queryParam:style=deepObject,explode=true,name=filter")
    private JsonNullable<? extends DocumentsListFilesQueryParamFilter> filter;

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page")
    @Deprecated
    private JsonNullable<String> page;

    /**
     * The number of results per page (default value is 25)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page_size")
    private JsonNullable<String> pageSize;

    /**
     * The unified cursor
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=next")
    private JsonNullable<String> next;

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=updated_after")
    @Deprecated
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=folder_id")
    private JsonNullable<String> folderId;

    /**
     * When "true" and used with filter[folder_id], the response includes Files and Files within descendant Folders
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=nested_items")
    private JsonNullable<String> nestedItems;

    /**
     * The comma separated list of fields that will be included in the response
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=include")
    private JsonNullable<String> include;

    @JsonCreator
    public DocumentsListFilesRequest(
            String xAccountId,
            Optional<String> xStackoneApiSessionToken,
            JsonNullable<Boolean> raw,
            JsonNullable<? extends Map<String, Object>> proxy,
            JsonNullable<String> fields,
            JsonNullable<? extends DocumentsListFilesQueryParamFilter> filter,
            JsonNullable<String> page,
            JsonNullable<String> pageSize,
            JsonNullable<String> next,
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<String> folderId,
            JsonNullable<String> nestedItems,
            JsonNullable<String> include) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        Utils.checkNotNull(raw, "raw");
        Utils.checkNotNull(proxy, "proxy");
        Utils.checkNotNull(fields, "fields");
        Utils.checkNotNull(filter, "filter");
        Utils.checkNotNull(page, "page");
        Utils.checkNotNull(pageSize, "pageSize");
        Utils.checkNotNull(next, "next");
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(folderId, "folderId");
        Utils.checkNotNull(nestedItems, "nestedItems");
        Utils.checkNotNull(include, "include");
        this.xAccountId = xAccountId;
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        this.raw = raw;
        this.proxy = proxy;
        this.fields = fields;
        this.filter = filter;
        this.page = page;
        this.pageSize = pageSize;
        this.next = next;
        this.updatedAfter = updatedAfter;
        this.folderId = folderId;
        this.nestedItems = nestedItems;
        this.include = include;
    }
    
    public DocumentsListFilesRequest(
            String xAccountId) {
        this(xAccountId, Optional.empty(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * The session token
     */
    @JsonIgnore
    public Optional<String> xStackoneApiSessionToken() {
        return xStackoneApiSessionToken;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    @JsonIgnore
    public JsonNullable<Boolean> raw() {
        return raw;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> proxy() {
        return (JsonNullable<Map<String, Object>>) proxy;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    @JsonIgnore
    public JsonNullable<String> fields() {
        return fields;
    }

    /**
     * Documents Files Filter
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<DocumentsListFilesQueryParamFilter> filter() {
        return (JsonNullable<DocumentsListFilesQueryParamFilter>) filter;
    }

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> page() {
        return page;
    }

    /**
     * The number of results per page (default value is 25)
     */
    @JsonIgnore
    public JsonNullable<String> pageSize() {
        return pageSize;
    }

    /**
     * The unified cursor
     */
    @JsonIgnore
    public JsonNullable<String> next() {
        return next;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    @JsonIgnore
    public JsonNullable<String> folderId() {
        return folderId;
    }

    /**
     * When "true" and used with filter[folder_id], the response includes Files and Files within descendant Folders
     */
    @JsonIgnore
    public JsonNullable<String> nestedItems() {
        return nestedItems;
    }

    /**
     * The comma separated list of fields that will be included in the response
     */
    @JsonIgnore
    public JsonNullable<String> include() {
        return include;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public DocumentsListFilesRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * The session token
     */
    public DocumentsListFilesRequest withXStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
        return this;
    }


    /**
     * The session token
     */
    public DocumentsListFilesRequest withXStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    public DocumentsListFilesRequest withRaw(boolean raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    public DocumentsListFilesRequest withRaw(JsonNullable<Boolean> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    public DocumentsListFilesRequest withProxy(Map<String, Object> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = JsonNullable.of(proxy);
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    public DocumentsListFilesRequest withProxy(JsonNullable<? extends Map<String, Object>> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = proxy;
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    public DocumentsListFilesRequest withFields(String fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = JsonNullable.of(fields);
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    public DocumentsListFilesRequest withFields(JsonNullable<String> fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = fields;
        return this;
    }

    /**
     * Documents Files Filter
     */
    public DocumentsListFilesRequest withFilter(DocumentsListFilesQueryParamFilter filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = JsonNullable.of(filter);
        return this;
    }

    /**
     * Documents Files Filter
     */
    public DocumentsListFilesRequest withFilter(JsonNullable<? extends DocumentsListFilesQueryParamFilter> filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = filter;
        return this;
    }

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public DocumentsListFilesRequest withPage(String page) {
        Utils.checkNotNull(page, "page");
        this.page = JsonNullable.of(page);
        return this;
    }

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public DocumentsListFilesRequest withPage(JsonNullable<String> page) {
        Utils.checkNotNull(page, "page");
        this.page = page;
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public DocumentsListFilesRequest withPageSize(String pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = JsonNullable.of(pageSize);
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public DocumentsListFilesRequest withPageSize(JsonNullable<String> pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = pageSize;
        return this;
    }

    /**
     * The unified cursor
     */
    public DocumentsListFilesRequest withNext(String next) {
        Utils.checkNotNull(next, "next");
        this.next = JsonNullable.of(next);
        return this;
    }

    /**
     * The unified cursor
     */
    public DocumentsListFilesRequest withNext(JsonNullable<String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public DocumentsListFilesRequest withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public DocumentsListFilesRequest withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    public DocumentsListFilesRequest withFolderId(String folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = JsonNullable.of(folderId);
        return this;
    }

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    public DocumentsListFilesRequest withFolderId(JsonNullable<String> folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = folderId;
        return this;
    }

    /**
     * When "true" and used with filter[folder_id], the response includes Files and Files within descendant Folders
     */
    public DocumentsListFilesRequest withNestedItems(String nestedItems) {
        Utils.checkNotNull(nestedItems, "nestedItems");
        this.nestedItems = JsonNullable.of(nestedItems);
        return this;
    }

    /**
     * When "true" and used with filter[folder_id], the response includes Files and Files within descendant Folders
     */
    public DocumentsListFilesRequest withNestedItems(JsonNullable<String> nestedItems) {
        Utils.checkNotNull(nestedItems, "nestedItems");
        this.nestedItems = nestedItems;
        return this;
    }

    /**
     * The comma separated list of fields that will be included in the response
     */
    public DocumentsListFilesRequest withInclude(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of(include);
        return this;
    }

    /**
     * The comma separated list of fields that will be included in the response
     */
    public DocumentsListFilesRequest withInclude(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DocumentsListFilesRequest other = (DocumentsListFilesRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.xStackoneApiSessionToken, other.xStackoneApiSessionToken) &&
            Utils.enhancedDeepEquals(this.raw, other.raw) &&
            Utils.enhancedDeepEquals(this.proxy, other.proxy) &&
            Utils.enhancedDeepEquals(this.fields, other.fields) &&
            Utils.enhancedDeepEquals(this.filter, other.filter) &&
            Utils.enhancedDeepEquals(this.page, other.page) &&
            Utils.enhancedDeepEquals(this.pageSize, other.pageSize) &&
            Utils.enhancedDeepEquals(this.next, other.next) &&
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.folderId, other.folderId) &&
            Utils.enhancedDeepEquals(this.nestedItems, other.nestedItems) &&
            Utils.enhancedDeepEquals(this.include, other.include);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, xStackoneApiSessionToken, raw,
            proxy, fields, filter,
            page, pageSize, next,
            updatedAfter, folderId, nestedItems,
            include);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DocumentsListFilesRequest.class,
                "xAccountId", xAccountId,
                "xStackoneApiSessionToken", xStackoneApiSessionToken,
                "raw", raw,
                "proxy", proxy,
                "fields", fields,
                "filter", filter,
                "page", page,
                "pageSize", pageSize,
                "next", next,
                "updatedAfter", updatedAfter,
                "folderId", folderId,
                "nestedItems", nestedItems,
                "include", include);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> xStackoneApiSessionToken = Optional.empty();

        private JsonNullable<Boolean> raw = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> proxy = JsonNullable.undefined();

        private JsonNullable<String> fields = JsonNullable.undefined();

        private JsonNullable<? extends DocumentsListFilesQueryParamFilter> filter = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<String> page = JsonNullable.undefined();

        private JsonNullable<String> pageSize = JsonNullable.undefined();

        private JsonNullable<String> next = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<String> folderId = JsonNullable.undefined();

        private JsonNullable<String> nestedItems;

        private JsonNullable<String> include = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
            return this;
        }

        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = xStackoneApiSessionToken;
            return this;
        }


        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
         */
        public Builder raw(boolean raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
         */
        public Builder raw(JsonNullable<Boolean> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }


        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
         */
        public Builder proxy(Map<String, Object> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = JsonNullable.of(proxy);
            return this;
        }

        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
         */
        public Builder proxy(JsonNullable<? extends Map<String, Object>> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = proxy;
            return this;
        }


        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
         */
        public Builder fields(String fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = JsonNullable.of(fields);
            return this;
        }

        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
         */
        public Builder fields(JsonNullable<String> fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = fields;
            return this;
        }


        /**
         * Documents Files Filter
         */
        public Builder filter(DocumentsListFilesQueryParamFilter filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = JsonNullable.of(filter);
            return this;
        }

        /**
         * Documents Files Filter
         */
        public Builder filter(JsonNullable<? extends DocumentsListFilesQueryParamFilter> filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = filter;
            return this;
        }


        /**
         * The page number of the results to fetch
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder page(String page) {
            Utils.checkNotNull(page, "page");
            this.page = JsonNullable.of(page);
            return this;
        }

        /**
         * The page number of the results to fetch
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder page(JsonNullable<String> page) {
            Utils.checkNotNull(page, "page");
            this.page = page;
            return this;
        }


        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(String pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = JsonNullable.of(pageSize);
            return this;
        }

        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(JsonNullable<String> pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = pageSize;
            return this;
        }


        /**
         * The unified cursor
         */
        public Builder next(String next) {
            Utils.checkNotNull(next, "next");
            this.next = JsonNullable.of(next);
            return this;
        }

        /**
         * The unified cursor
         */
        public Builder next(JsonNullable<String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }


        /**
         * Use a string with a date to only select results updated after that given date
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Use to only include Files within the specified Folder. Required when requesting nested items
         */
        public Builder folderId(String folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = JsonNullable.of(folderId);
            return this;
        }

        /**
         * Use to only include Files within the specified Folder. Required when requesting nested items
         */
        public Builder folderId(JsonNullable<String> folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = folderId;
            return this;
        }


        /**
         * When "true" and used with filter[folder_id], the response includes Files and Files within descendant Folders
         */
        public Builder nestedItems(String nestedItems) {
            Utils.checkNotNull(nestedItems, "nestedItems");
            this.nestedItems = JsonNullable.of(nestedItems);
            return this;
        }

        /**
         * When "true" and used with filter[folder_id], the response includes Files and Files within descendant Folders
         */
        public Builder nestedItems(JsonNullable<String> nestedItems) {
            Utils.checkNotNull(nestedItems, "nestedItems");
            this.nestedItems = nestedItems;
            return this;
        }


        /**
         * The comma separated list of fields that will be included in the response
         */
        public Builder include(String include) {
            Utils.checkNotNull(include, "include");
            this.include = JsonNullable.of(include);
            return this;
        }

        /**
         * The comma separated list of fields that will be included in the response
         */
        public Builder include(JsonNullable<String> include) {
            Utils.checkNotNull(include, "include");
            this.include = include;
            return this;
        }

        public DocumentsListFilesRequest build() {
            if (nestedItems == null) {
                nestedItems = _SINGLETON_VALUE_NestedItems.value();
            }

            return new DocumentsListFilesRequest(
                xAccountId, xStackoneApiSessionToken, raw,
                proxy, fields, filter,
                page, pageSize, next,
                updatedAfter, folderId, nestedItems,
                include);
        }


        private static final LazySingletonValue<JsonNullable<String>> _SINGLETON_VALUE_NestedItems =
                new LazySingletonValue<>(
                        "nested_items",
                        "\"false\"",
                        new TypeReference<JsonNullable<String>>() {});
    }
}
