/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;
import static com.stackone.stackone_client_java.utils.reactive.ReactiveUtils.mapAsync;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectComponentsRequest;
import com.stackone.stackone_client_java.operations.TicketingListProjectComponents;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import java.lang.Exception;
import java.lang.String;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class TicketingListProjectComponentsRequestBuilder {

    private TicketingListProjectComponentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public TicketingListProjectComponentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingListProjectComponentsRequestBuilder request(TicketingListProjectComponentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public TicketingListProjectComponentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingListProjectComponentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<TicketingListProjectComponentsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<TicketingListProjectComponentsRequest, TicketingListProjectComponentsResponse> operation
              = new TicketingListProjectComponents.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

    /**
     * Returns a Publisher that performs next page calls till no more pages
     * are returned.
     *
     * <p>The returned publisher can be used with reactive frameworks:
     * <pre><code>
     * Publisher&lt;TicketingListProjectComponentsResponse&gt; publisher = builder.callAsPublisher();
     * publisher.subscribe(new Subscriber&lt;TicketingListProjectComponentsResponse&gt;() {
     *     // Handle onNext, onError, onComplete
     * });
     * </code></pre>
     *
     * @return A Publisher that emits pages asynchronously
     */
    public Publisher<TicketingListProjectComponentsResponse> callAsPublisher() {
        TicketingListProjectComponentsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<TicketingListProjectComponentsRequest, TicketingListProjectComponentsResponse> operation
              = new TicketingListProjectComponents.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());

        Flow.Publisher<HttpResponse<Blob>> asyncPaginator = new AsyncPaginator<>(
            request,
            new CursorTracker<>("$.next", String.class),
                    TicketingListProjectComponentsRequest::withNext,
            operation::doRequest);

        Flow.Publisher<TicketingListProjectComponentsResponse> flowPublisher = mapAsync(asyncPaginator, operation::handleResponse);

        // Convert Flow.Publisher to Reactive Streams Publisher at the last stage
        return FlowAdapters.toPublisher(flowPublisher);
    }

}
