/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
@JsonDeserialize(using = LmsUpsertContentRequestDtoValue._Deserializer.class)
@JsonSerialize(using = LmsUpsertContentRequestDtoValue._Serializer.class)
public class LmsUpsertContentRequestDtoValue {

    public static final LmsUpsertContentRequestDtoValue VIDEO = new LmsUpsertContentRequestDtoValue("video");
    public static final LmsUpsertContentRequestDtoValue QUIZ = new LmsUpsertContentRequestDtoValue("quiz");
    public static final LmsUpsertContentRequestDtoValue DOCUMENT = new LmsUpsertContentRequestDtoValue("document");
    public static final LmsUpsertContentRequestDtoValue AUDIO = new LmsUpsertContentRequestDtoValue("audio");
    public static final LmsUpsertContentRequestDtoValue ARTICLE = new LmsUpsertContentRequestDtoValue("article");
    public static final LmsUpsertContentRequestDtoValue BOOK = new LmsUpsertContentRequestDtoValue("book");
    public static final LmsUpsertContentRequestDtoValue EVENT = new LmsUpsertContentRequestDtoValue("event");
    public static final LmsUpsertContentRequestDtoValue COURSE = new LmsUpsertContentRequestDtoValue("course");
    public static final LmsUpsertContentRequestDtoValue COLLECTION = new LmsUpsertContentRequestDtoValue("collection");
    public static final LmsUpsertContentRequestDtoValue INTERACTIVE = new LmsUpsertContentRequestDtoValue("interactive");
    public static final LmsUpsertContentRequestDtoValue UNMAPPED_VALUE = new LmsUpsertContentRequestDtoValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, LmsUpsertContentRequestDtoValue> values = createValuesMap();
    private static final Map<String, LmsUpsertContentRequestDtoValueEnum> enums = createEnumsMap();

    private final String value;

    private LmsUpsertContentRequestDtoValue(String value) {
        this.value = value;
    }

    /**
     * Returns a LmsUpsertContentRequestDtoValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as LmsUpsertContentRequestDtoValue
     */ 
    public static LmsUpsertContentRequestDtoValue of(String value) {
        synchronized (LmsUpsertContentRequestDtoValue.class) {
            return values.computeIfAbsent(value, v -> new LmsUpsertContentRequestDtoValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<LmsUpsertContentRequestDtoValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        LmsUpsertContentRequestDtoValue other = (LmsUpsertContentRequestDtoValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "LmsUpsertContentRequestDtoValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static LmsUpsertContentRequestDtoValue[] values() {
        synchronized (LmsUpsertContentRequestDtoValue.class) {
            return values.values().toArray(new LmsUpsertContentRequestDtoValue[] {});
        }
    }

    private static final Map<String, LmsUpsertContentRequestDtoValue> createValuesMap() {
        Map<String, LmsUpsertContentRequestDtoValue> map = new LinkedHashMap<>();
        map.put("video", VIDEO);
        map.put("quiz", QUIZ);
        map.put("document", DOCUMENT);
        map.put("audio", AUDIO);
        map.put("article", ARTICLE);
        map.put("book", BOOK);
        map.put("event", EVENT);
        map.put("course", COURSE);
        map.put("collection", COLLECTION);
        map.put("interactive", INTERACTIVE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, LmsUpsertContentRequestDtoValueEnum> createEnumsMap() {
        Map<String, LmsUpsertContentRequestDtoValueEnum> map = new HashMap<>();
        map.put("video", LmsUpsertContentRequestDtoValueEnum.VIDEO);
        map.put("quiz", LmsUpsertContentRequestDtoValueEnum.QUIZ);
        map.put("document", LmsUpsertContentRequestDtoValueEnum.DOCUMENT);
        map.put("audio", LmsUpsertContentRequestDtoValueEnum.AUDIO);
        map.put("article", LmsUpsertContentRequestDtoValueEnum.ARTICLE);
        map.put("book", LmsUpsertContentRequestDtoValueEnum.BOOK);
        map.put("event", LmsUpsertContentRequestDtoValueEnum.EVENT);
        map.put("course", LmsUpsertContentRequestDtoValueEnum.COURSE);
        map.put("collection", LmsUpsertContentRequestDtoValueEnum.COLLECTION);
        map.put("interactive", LmsUpsertContentRequestDtoValueEnum.INTERACTIVE);
        map.put("unmapped_value", LmsUpsertContentRequestDtoValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<LmsUpsertContentRequestDtoValue> {

        protected _Serializer() {
            super(LmsUpsertContentRequestDtoValue.class);
        }

        @Override
        public void serialize(LmsUpsertContentRequestDtoValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<LmsUpsertContentRequestDtoValue> {

        protected _Deserializer() {
            super(LmsUpsertContentRequestDtoValue.class);
        }

        @Override
        public LmsUpsertContentRequestDtoValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return LmsUpsertContentRequestDtoValue.of(v);
        }
    }
    
    public enum LmsUpsertContentRequestDtoValueEnum {

        VIDEO("video"),
        QUIZ("quiz"),
        DOCUMENT("document"),
        AUDIO("audio"),
        ARTICLE("article"),
        BOOK("book"),
        EVENT("event"),
        COURSE("course"),
        COLLECTION("collection"),
        INTERACTIVE("interactive"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private LmsUpsertContentRequestDtoValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

