/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * TimeOffPolicyValue
 * 
 * <p>The unified value for the type of the time off policy. If the provider does not specify this unit,
 * the value will be set to unmapped_value
 */
@JsonDeserialize(using = TimeOffPolicyValue._Deserializer.class)
@JsonSerialize(using = TimeOffPolicyValue._Serializer.class)
public class TimeOffPolicyValue {

    public static final TimeOffPolicyValue SICK = new TimeOffPolicyValue("sick");
    public static final TimeOffPolicyValue UNMAPPED_VALUE = new TimeOffPolicyValue("unmapped_value");
    public static final TimeOffPolicyValue VACATION = new TimeOffPolicyValue("vacation");
    public static final TimeOffPolicyValue LONG_TERM_DISABILITY = new TimeOffPolicyValue("long_term_disability");
    public static final TimeOffPolicyValue SHORT_TERM_DISABILITY = new TimeOffPolicyValue("short_term_disability");
    public static final TimeOffPolicyValue ABSENT = new TimeOffPolicyValue("absent");
    public static final TimeOffPolicyValue COMP_TIME = new TimeOffPolicyValue("comp_time");
    public static final TimeOffPolicyValue TRAINING = new TimeOffPolicyValue("training");
    public static final TimeOffPolicyValue ANNUAL_LEAVE = new TimeOffPolicyValue("annual_leave");
    public static final TimeOffPolicyValue LEAVE_OF_ABSENCE = new TimeOffPolicyValue("leave_of_absence");
    public static final TimeOffPolicyValue BREAK = new TimeOffPolicyValue("break");
    public static final TimeOffPolicyValue CHILD_CARE_LEAVE = new TimeOffPolicyValue("child_care_leave");
    public static final TimeOffPolicyValue MATERNITY_LEAVE = new TimeOffPolicyValue("maternity_leave");
    public static final TimeOffPolicyValue JURY_DUTY = new TimeOffPolicyValue("jury_duty");
    public static final TimeOffPolicyValue SABBATICAL = new TimeOffPolicyValue("sabbatical");
    public static final TimeOffPolicyValue ACCIDENT = new TimeOffPolicyValue("accident");
    public static final TimeOffPolicyValue PAID = new TimeOffPolicyValue("paid");
    public static final TimeOffPolicyValue UNPAID = new TimeOffPolicyValue("unpaid");
    public static final TimeOffPolicyValue HOLIDAY = new TimeOffPolicyValue("holiday");
    public static final TimeOffPolicyValue PERSONAL = new TimeOffPolicyValue("personal");
    public static final TimeOffPolicyValue IN_LIEU = new TimeOffPolicyValue("in_lieu");
    public static final TimeOffPolicyValue BEREAVEMENT = new TimeOffPolicyValue("bereavement");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TimeOffPolicyValue> values = createValuesMap();
    private static final Map<String, TimeOffPolicyValueEnum> enums = createEnumsMap();

    private final String value;

    private TimeOffPolicyValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TimeOffPolicyValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TimeOffPolicyValue
     */ 
    public static TimeOffPolicyValue of(String value) {
        synchronized (TimeOffPolicyValue.class) {
            return values.computeIfAbsent(value, v -> new TimeOffPolicyValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<TimeOffPolicyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeOffPolicyValue other = (TimeOffPolicyValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TimeOffPolicyValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TimeOffPolicyValue[] values() {
        synchronized (TimeOffPolicyValue.class) {
            return values.values().toArray(new TimeOffPolicyValue[] {});
        }
    }

    private static final Map<String, TimeOffPolicyValue> createValuesMap() {
        Map<String, TimeOffPolicyValue> map = new LinkedHashMap<>();
        map.put("sick", SICK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("vacation", VACATION);
        map.put("long_term_disability", LONG_TERM_DISABILITY);
        map.put("short_term_disability", SHORT_TERM_DISABILITY);
        map.put("absent", ABSENT);
        map.put("comp_time", COMP_TIME);
        map.put("training", TRAINING);
        map.put("annual_leave", ANNUAL_LEAVE);
        map.put("leave_of_absence", LEAVE_OF_ABSENCE);
        map.put("break", BREAK);
        map.put("child_care_leave", CHILD_CARE_LEAVE);
        map.put("maternity_leave", MATERNITY_LEAVE);
        map.put("jury_duty", JURY_DUTY);
        map.put("sabbatical", SABBATICAL);
        map.put("accident", ACCIDENT);
        map.put("paid", PAID);
        map.put("unpaid", UNPAID);
        map.put("holiday", HOLIDAY);
        map.put("personal", PERSONAL);
        map.put("in_lieu", IN_LIEU);
        map.put("bereavement", BEREAVEMENT);
        return map;
    }

    private static final Map<String, TimeOffPolicyValueEnum> createEnumsMap() {
        Map<String, TimeOffPolicyValueEnum> map = new HashMap<>();
        map.put("sick", TimeOffPolicyValueEnum.SICK);
        map.put("unmapped_value", TimeOffPolicyValueEnum.UNMAPPED_VALUE);
        map.put("vacation", TimeOffPolicyValueEnum.VACATION);
        map.put("long_term_disability", TimeOffPolicyValueEnum.LONG_TERM_DISABILITY);
        map.put("short_term_disability", TimeOffPolicyValueEnum.SHORT_TERM_DISABILITY);
        map.put("absent", TimeOffPolicyValueEnum.ABSENT);
        map.put("comp_time", TimeOffPolicyValueEnum.COMP_TIME);
        map.put("training", TimeOffPolicyValueEnum.TRAINING);
        map.put("annual_leave", TimeOffPolicyValueEnum.ANNUAL_LEAVE);
        map.put("leave_of_absence", TimeOffPolicyValueEnum.LEAVE_OF_ABSENCE);
        map.put("break", TimeOffPolicyValueEnum.BREAK);
        map.put("child_care_leave", TimeOffPolicyValueEnum.CHILD_CARE_LEAVE);
        map.put("maternity_leave", TimeOffPolicyValueEnum.MATERNITY_LEAVE);
        map.put("jury_duty", TimeOffPolicyValueEnum.JURY_DUTY);
        map.put("sabbatical", TimeOffPolicyValueEnum.SABBATICAL);
        map.put("accident", TimeOffPolicyValueEnum.ACCIDENT);
        map.put("paid", TimeOffPolicyValueEnum.PAID);
        map.put("unpaid", TimeOffPolicyValueEnum.UNPAID);
        map.put("holiday", TimeOffPolicyValueEnum.HOLIDAY);
        map.put("personal", TimeOffPolicyValueEnum.PERSONAL);
        map.put("in_lieu", TimeOffPolicyValueEnum.IN_LIEU);
        map.put("bereavement", TimeOffPolicyValueEnum.BEREAVEMENT);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<TimeOffPolicyValue> {

        protected _Serializer() {
            super(TimeOffPolicyValue.class);
        }

        @Override
        public void serialize(TimeOffPolicyValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<TimeOffPolicyValue> {

        protected _Deserializer() {
            super(TimeOffPolicyValue.class);
        }

        @Override
        public TimeOffPolicyValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return TimeOffPolicyValue.of(v);
        }
    }
    
    public enum TimeOffPolicyValueEnum {

        SICK("sick"),
        UNMAPPED_VALUE("unmapped_value"),
        VACATION("vacation"),
        LONG_TERM_DISABILITY("long_term_disability"),
        SHORT_TERM_DISABILITY("short_term_disability"),
        ABSENT("absent"),
        COMP_TIME("comp_time"),
        TRAINING("training"),
        ANNUAL_LEAVE("annual_leave"),
        LEAVE_OF_ABSENCE("leave_of_absence"),
        BREAK("break"),
        CHILD_CARE_LEAVE("child_care_leave"),
        MATERNITY_LEAVE("maternity_leave"),
        JURY_DUTY("jury_duty"),
        SABBATICAL("sabbatical"),
        ACCIDENT("accident"),
        PAID("paid"),
        UNPAID("unpaid"),
        HOLIDAY("holiday"),
        PERSONAL("personal"),
        IN_LIEU("in_lieu"),
        BEREAVEMENT("bereavement"),;

        private final String value;

        private TimeOffPolicyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

