/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.operations.StackoneGetConnectorMeta;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneGetConnectorMetaRequestBuilder {

    private String provider;
    private JsonNullable<String> include = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public StackoneGetConnectorMetaRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneGetConnectorMetaRequestBuilder provider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder include(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of(include);
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder include(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }
                
    public StackoneGetConnectorMetaRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private StackoneGetConnectorMetaRequest buildRequest() {

        StackoneGetConnectorMetaRequest request = new StackoneGetConnectorMetaRequest(provider,
            include);

        return request;
    }

    public StackoneGetConnectorMetaResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<StackoneGetConnectorMetaRequest, StackoneGetConnectorMetaResponse> operation
              = new StackoneGetConnectorMeta.Sync(sdkConfiguration, options, _headers);
        StackoneGetConnectorMetaRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
