/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.HrisInviteEmployeeRequestDto;
import com.stackone.stackone_client_java.models.operations.HrisInviteEmployeeRequest;
import com.stackone.stackone_client_java.operations.HrisInviteEmployee;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class HrisInviteEmployeeRequestBuilder {

    private String xAccountId;
    private String id;
    private HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public HrisInviteEmployeeRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisInviteEmployeeRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisInviteEmployeeRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisInviteEmployeeRequestBuilder hrisInviteEmployeeRequestDto(HrisInviteEmployeeRequestDto hrisInviteEmployeeRequestDto) {
        Utils.checkNotNull(hrisInviteEmployeeRequestDto, "hrisInviteEmployeeRequestDto");
        this.hrisInviteEmployeeRequestDto = hrisInviteEmployeeRequestDto;
        return this;
    }
                
    public HrisInviteEmployeeRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisInviteEmployeeRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private HrisInviteEmployeeRequest buildRequest() {

        HrisInviteEmployeeRequest request = new HrisInviteEmployeeRequest(xAccountId,
            id,
            hrisInviteEmployeeRequestDto);

        return request;
    }

    public CompletableFuture<HrisInviteEmployeeResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<HrisInviteEmployeeRequest, HrisInviteEmployeeResponse> operation
              = new HrisInviteEmployee.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        HrisInviteEmployeeRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
