/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * CreateMessageValue
 * 
 * <p>The unified message type.
 */
@JsonDeserialize(using = CreateMessageValue._Deserializer.class)
@JsonSerialize(using = CreateMessageValue._Serializer.class)
public class CreateMessageValue {

    public static final CreateMessageValue EMAIL = new CreateMessageValue("email");
    public static final CreateMessageValue SMS = new CreateMessageValue("sms");
    public static final CreateMessageValue PUSH = new CreateMessageValue("push");
    public static final CreateMessageValue WEB_PUSH = new CreateMessageValue("web_push");
    public static final CreateMessageValue IOS_PUSH = new CreateMessageValue("ios_push");
    public static final CreateMessageValue ANDROID_PUSH = new CreateMessageValue("android_push");
    public static final CreateMessageValue APP_PUSH = new CreateMessageValue("app_push");
    public static final CreateMessageValue OMNI_CHANNEL = new CreateMessageValue("omni_channel");
    public static final CreateMessageValue CONTENT_BLOCK = new CreateMessageValue("content_block");
    public static final CreateMessageValue IN_APP = new CreateMessageValue("in_app");
    public static final CreateMessageValue UNKNOWN = new CreateMessageValue("unknown");
    public static final CreateMessageValue UNMAPPED_VALUE = new CreateMessageValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CreateMessageValue> values = createValuesMap();
    private static final Map<String, CreateMessageValueEnum> enums = createEnumsMap();

    private final String value;

    private CreateMessageValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CreateMessageValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CreateMessageValue
     */ 
    public static CreateMessageValue of(String value) {
        synchronized (CreateMessageValue.class) {
            return values.computeIfAbsent(value, v -> new CreateMessageValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<CreateMessageValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CreateMessageValue other = (CreateMessageValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CreateMessageValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CreateMessageValue[] values() {
        synchronized (CreateMessageValue.class) {
            return values.values().toArray(new CreateMessageValue[] {});
        }
    }

    private static final Map<String, CreateMessageValue> createValuesMap() {
        Map<String, CreateMessageValue> map = new LinkedHashMap<>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateMessageValueEnum> createEnumsMap() {
        Map<String, CreateMessageValueEnum> map = new HashMap<>();
        map.put("email", CreateMessageValueEnum.EMAIL);
        map.put("sms", CreateMessageValueEnum.SMS);
        map.put("push", CreateMessageValueEnum.PUSH);
        map.put("web_push", CreateMessageValueEnum.WEB_PUSH);
        map.put("ios_push", CreateMessageValueEnum.IOS_PUSH);
        map.put("android_push", CreateMessageValueEnum.ANDROID_PUSH);
        map.put("app_push", CreateMessageValueEnum.APP_PUSH);
        map.put("omni_channel", CreateMessageValueEnum.OMNI_CHANNEL);
        map.put("content_block", CreateMessageValueEnum.CONTENT_BLOCK);
        map.put("in_app", CreateMessageValueEnum.IN_APP);
        map.put("unknown", CreateMessageValueEnum.UNKNOWN);
        map.put("unmapped_value", CreateMessageValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<CreateMessageValue> {

        protected _Serializer() {
            super(CreateMessageValue.class);
        }

        @Override
        public void serialize(CreateMessageValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<CreateMessageValue> {

        protected _Deserializer() {
            super(CreateMessageValue.class);
        }

        @Override
        public CreateMessageValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return CreateMessageValue.of(v);
        }
    }
    
    public enum CreateMessageValueEnum {

        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CreateMessageValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

