/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AccountingJournalStatus
 * 
 * <p>Status of the journal
 */
public class AccountingJournalStatus {
    /**
     * The journal status
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AccountingJournalValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AccountingJournalSourceValue> sourceValue;

    @JsonCreator
    public AccountingJournalStatus(
            @JsonProperty("value") JsonNullable<? extends AccountingJournalValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AccountingJournalSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AccountingJournalStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The journal status
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingJournalValue> value() {
        return (JsonNullable<AccountingJournalValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingJournalSourceValue> sourceValue() {
        return (JsonNullable<AccountingJournalSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The journal status
     */
    public AccountingJournalStatus withValue(AccountingJournalValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The journal status
     */
    public AccountingJournalStatus withValue(JsonNullable<? extends AccountingJournalValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public AccountingJournalStatus withSourceValue(AccountingJournalSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public AccountingJournalStatus withSourceValue(JsonNullable<? extends AccountingJournalSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingJournalStatus other = (AccountingJournalStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingJournalStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends AccountingJournalValue> value = JsonNullable.undefined();

        private JsonNullable<? extends AccountingJournalSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The journal status
         */
        public Builder value(AccountingJournalValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The journal status
         */
        public Builder value(JsonNullable<? extends AccountingJournalValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(AccountingJournalSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AccountingJournalSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public AccountingJournalStatus build() {

            return new AccountingJournalStatus(
                value, sourceValue);
        }

    }
}
