/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;
import static com.stackone.stackone_client_java.utils.Exceptions.unchecked;
import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.HRISCostCenterResult;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.PreconditionFailedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.HrisGetCostCenterGroupRequest;
import com.stackone.stackone_client_java.models.operations.HrisGetCostCenterGroupResponse;
import com.stackone.stackone_client_java.utils.AsyncRetries;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Hook.AfterErrorContextImpl;
import com.stackone.stackone_client_java.utils.Hook.AfterSuccessContextImpl;
import com.stackone.stackone_client_java.utils.Hook.BeforeRequestContextImpl;
import com.stackone.stackone_client_java.utils.NonRetryableException;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Exception;
import java.lang.String;
import java.lang.Throwable;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;


public class HrisGetCostCenterGroup {

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;
        final Headers _headers;

        public Base(
                SDKConfiguration sdkConfiguration, Optional<Options> options,
                Headers _headers) {
            this.sdkConfiguration = sdkConfiguration;
            this._headers =_headers;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options
                    .ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("429", "408");
            this.retryConfig = options
                    .flatMap(Options::retryConfig)
                    .or(sdkConfiguration::retryConfig)
                    .orElse(RetryConfig.builder().backoff(BackoffStrategy.builder()
                                    .initialInterval(500, TimeUnit.MILLISECONDS)
                                    .maxInterval(60000, TimeUnit.MILLISECONDS)
                                    .baseFactor((double) (1.5))
                                    .maxElapsedTime(3600000, TimeUnit.MILLISECONDS)
                                    .retryConnectError(true)
                                    .build())
                            .build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        BeforeRequestContextImpl createBeforeRequestContext() {
            return new BeforeRequestContextImpl(
                    this.sdkConfiguration,
                    this.baseUrl,
                    "hris_get_cost_center_group",
                    java.util.Optional.empty(),
                    securitySource());
        }

        AfterSuccessContextImpl createAfterSuccessContext() {
            return new AfterSuccessContextImpl(
                    this.sdkConfiguration,
                    this.baseUrl,
                    "hris_get_cost_center_group",
                    java.util.Optional.empty(),
                    securitySource());
        }

        AfterErrorContextImpl createAfterErrorContext() {
            return new AfterErrorContextImpl(
                    this.sdkConfiguration,
                    this.baseUrl,
                    "hris_get_cost_center_group",
                    java.util.Optional.empty(),
                    securitySource());
        }
        <T>HttpRequest buildRequest(T request, Class<T> klass) throws Exception {
            String url = Utils.generateURL(
                    klass,
                    this.baseUrl,
                    "/unified/hris/groups/cost_centers/{id}",
                    request, null);
            HTTPRequest req = new HTTPRequest(url, "GET");
            req.addHeader("Accept", "application/json")
                    .addHeader("user-agent", SDKConfiguration.USER_AGENT);
            _headers.forEach((k, list) -> list.forEach(v -> req.addHeader(k, v)));

            req.addQueryParams(Utils.getQueryParams(
                    klass,
                    request,
                    null));
            req.addHeaders(Utils.getHeadersFromMetadata(request, null));
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());

            return req.build();
        }
    }

    public static class Sync extends Base
            implements RequestOperation<HrisGetCostCenterGroupRequest, HrisGetCostCenterGroupResponse> {
        public Sync(
                SDKConfiguration sdkConfiguration, Optional<Options> options,
                Headers _headers) {
            super(
                  sdkConfiguration, options,
                  _headers);
        }

        private HttpRequest onBuildRequest(HrisGetCostCenterGroupRequest request) throws Exception {
            HttpRequest req = buildRequest(request, HrisGetCostCenterGroupRequest.class);
            return sdkConfiguration.hooks().beforeRequest(createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return sdkConfiguration.hooks().afterError(
                    createAfterErrorContext(),
                    Optional.ofNullable(response),
                    Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return sdkConfiguration.hooks().afterSuccess(createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(HrisGetCostCenterGroupRequest request) {
            Retries retries = Retries.builder()
                    .action(() -> {
                        HttpRequest r;
                        try {
                            r = onBuildRequest(request);
                        } catch (Exception e) {
                            throw new NonRetryableException(e);
                        }
                        try {
                            HttpResponse<InputStream> httpRes = client.send(r);
                            if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                                return onError(httpRes, null);
                            }
                            return httpRes;
                        } catch (Exception e) {
                            return onError(null, e);
                        }
                    })
                    .retryConfig(retryConfig)
                    .statusCodes(retryStatusCodes)
                    .build();
            return unchecked(() -> onSuccess(retries.run())).get();
        }


        @Override
        public HrisGetCostCenterGroupResponse handleResponse(HttpResponse<InputStream> response) {
            String contentType = response
                    .headers()
                    .firstValue("Content-Type")
                    .orElse("application/octet-stream");
            HrisGetCostCenterGroupResponse.Builder resBuilder =
                    HrisGetCostCenterGroupResponse
                            .builder()
                            .contentType(contentType)
                            .statusCode(response.statusCode())
                            .rawResponse(response);

            HrisGetCostCenterGroupResponse res = resBuilder.build();
            
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return res.withHRISCostCenterResult(Utils.unmarshal(response, new TypeReference<HRISCostCenterResult>() {}));
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw BadRequestResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw UnauthorizedResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw ForbiddenResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw NotFoundResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw RequestTimedOutResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw ConflictResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw PreconditionFailedResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw UnprocessableEntityResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw TooManyRequestsResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw InternalServerErrorResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw NotImplementedResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw BadGatewayResponse.from(response);
                } else {
                    throw SDKError.from("Unexpected content-type received: " + contentType, response);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                // no content
                throw SDKError.from("API error occurred", response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                // no content
                throw SDKError.from("API error occurred", response);
            }
            throw SDKError.from("Unexpected status code received: " + response.statusCode(), response);
        }
    }
    public static class Async extends Base
            implements AsyncRequestOperation<HrisGetCostCenterGroupRequest, com.stackone.stackone_client_java.models.operations.async.HrisGetCostCenterGroupResponse> {
        private final ScheduledExecutorService retryScheduler;

        public Async(
                SDKConfiguration sdkConfiguration, Optional<Options> options,
                ScheduledExecutorService retryScheduler, Headers _headers) {
            super(
                  sdkConfiguration, options,
                  _headers);
            this.retryScheduler = retryScheduler;
        }

        private CompletableFuture<HttpRequest> onBuildRequest(HrisGetCostCenterGroupRequest request) throws Exception {
            HttpRequest req = buildRequest(request, HrisGetCostCenterGroupRequest.class);
            return this.sdkConfiguration.asyncHooks().beforeRequest(createBeforeRequestContext(), req);
        }

        private CompletableFuture<HttpResponse<Blob>> onError(HttpResponse<Blob> response, Throwable error) {
            return this.sdkConfiguration.asyncHooks().afterError(createAfterErrorContext(), response, error);
        }

        private CompletableFuture<HttpResponse<Blob>> onSuccess(HttpResponse<Blob> response) {
            return this.sdkConfiguration.asyncHooks().afterSuccess(createAfterSuccessContext(), response);
        }

        @Override
        public CompletableFuture<HttpResponse<Blob>> doRequest(HrisGetCostCenterGroupRequest request) {
            AsyncRetries retries = AsyncRetries.builder()
                    .retryConfig(retryConfig)
                    .statusCodes(retryStatusCodes)
                    .scheduler(retryScheduler)
                    .build();
            return retries.retry(() -> unchecked(() -> onBuildRequest(request)).get().thenCompose(client::sendAsync)
                            .handle((resp, err) -> {
                                if (err != null) {
                                    return onError(null, err);
                                }
                                if (Utils.statusCodeMatches(resp.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                                    return onError(resp, null);
                                }
                                return CompletableFuture.completedFuture(resp);
                            })
                            .thenCompose(Function.identity()))
                    .thenCompose(this::onSuccess);
        }

        @Override
        public CompletableFuture<com.stackone.stackone_client_java.models.operations.async.HrisGetCostCenterGroupResponse> handleResponse(
                HttpResponse<Blob> response) {
            String contentType = response
                    .headers()
                    .firstValue("Content-Type")
                    .orElse("application/octet-stream");
            com.stackone.stackone_client_java.models.operations.async.HrisGetCostCenterGroupResponse.Builder resBuilder =
                    com.stackone.stackone_client_java.models.operations.async.HrisGetCostCenterGroupResponse
                            .builder()
                            .contentType(contentType)
                            .statusCode(response.statusCode())
                            .rawResponse(response);

            com.stackone.stackone_client_java.models.operations.async.HrisGetCostCenterGroupResponse res = resBuilder.build();
            
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return Utils.unmarshalAsync(response, new TypeReference<HRISCostCenterResult>() {})
                            .thenApply(res::withHRISCostCenterResult);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return BadRequestResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return UnauthorizedResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return ForbiddenResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return NotFoundResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return RequestTimedOutResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return ConflictResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return PreconditionFailedResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return UnprocessableEntityResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return TooManyRequestsResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return InternalServerErrorResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return NotImplementedResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return BadGatewayResponse.fromAsync(response)
                            .thenCompose(CompletableFuture::failedFuture);
                } else {
                    return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
                }
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                // no content
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                // no content
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            return Utils.createAsyncApiError(response, "Unexpected status code received: " + response.statusCode());
        }
    }
}
