/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListEmployeesQueryParamFilter
 * 
 * <p>HRIS Employees filters
 */
public class HrisListEmployeesQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Filter to select employees by email
     */
    @SpeakeasyMetadata("queryParam:name=email")
    private JsonNullable<String> email;

    /**
     * Filter to select employees by employee_number
     */
    @SpeakeasyMetadata("queryParam:name=employee_number")
    private JsonNullable<String> employeeNumber;

    @JsonCreator
    public HrisListEmployeesQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<String> email,
            JsonNullable<String> employeeNumber) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(employeeNumber, "employeeNumber");
        this.updatedAfter = updatedAfter;
        this.email = email;
        this.employeeNumber = employeeNumber;
    }
    
    public HrisListEmployeesQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to select employees by email
     */
    @JsonIgnore
    public JsonNullable<String> email() {
        return email;
    }

    /**
     * Filter to select employees by employee_number
     */
    @JsonIgnore
    public JsonNullable<String> employeeNumber() {
        return employeeNumber;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeesQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeesQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to select employees by email
     */
    public HrisListEmployeesQueryParamFilter withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = JsonNullable.of(email);
        return this;
    }

    /**
     * Filter to select employees by email
     */
    public HrisListEmployeesQueryParamFilter withEmail(JsonNullable<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    /**
     * Filter to select employees by employee_number
     */
    public HrisListEmployeesQueryParamFilter withEmployeeNumber(String employeeNumber) {
        Utils.checkNotNull(employeeNumber, "employeeNumber");
        this.employeeNumber = JsonNullable.of(employeeNumber);
        return this;
    }

    /**
     * Filter to select employees by employee_number
     */
    public HrisListEmployeesQueryParamFilter withEmployeeNumber(JsonNullable<String> employeeNumber) {
        Utils.checkNotNull(employeeNumber, "employeeNumber");
        this.employeeNumber = employeeNumber;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeesQueryParamFilter other = (HrisListEmployeesQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.email, other.email) &&
            Utils.enhancedDeepEquals(this.employeeNumber, other.employeeNumber);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, email, employeeNumber);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListEmployeesQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "email", email,
                "employeeNumber", employeeNumber);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<String> email = JsonNullable.undefined();

        private JsonNullable<String> employeeNumber = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Filter to select employees by email
         */
        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = JsonNullable.of(email);
            return this;
        }

        /**
         * Filter to select employees by email
         */
        public Builder email(JsonNullable<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }


        /**
         * Filter to select employees by employee_number
         */
        public Builder employeeNumber(String employeeNumber) {
            Utils.checkNotNull(employeeNumber, "employeeNumber");
            this.employeeNumber = JsonNullable.of(employeeNumber);
            return this;
        }

        /**
         * Filter to select employees by employee_number
         */
        public Builder employeeNumber(JsonNullable<String> employeeNumber) {
            Utils.checkNotNull(employeeNumber, "employeeNumber");
            this.employeeNumber = employeeNumber;
            return this;
        }

        public HrisListEmployeesQueryParamFilter build() {

            return new HrisListEmployeesQueryParamFilter(
                updatedAfter, email, employeeNumber);
        }

    }
}
