/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class StackoneGetLogRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * The include parameter allows you to include additional data in the response.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=include")
    private JsonNullable<? extends Include> include;

    @JsonCreator
    public StackoneGetLogRequest(
            String id,
            JsonNullable<? extends Include> include) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(include, "include");
        this.id = id;
        this.include = include;
    }
    
    public StackoneGetLogRequest(
            String id) {
        this(id, JsonNullable.undefined());
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * The include parameter allows you to include additional data in the response.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Include> include() {
        return (JsonNullable<Include>) include;
    }

    public static Builder builder() {
        return new Builder();
    }


    public StackoneGetLogRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The include parameter allows you to include additional data in the response.
     */
    public StackoneGetLogRequest withInclude(Include include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of(include);
        return this;
    }

    /**
     * The include parameter allows you to include additional data in the response.
     */
    public StackoneGetLogRequest withInclude(JsonNullable<? extends Include> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneGetLogRequest other = (StackoneGetLogRequest) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.include, other.include);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, include);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneGetLogRequest.class,
                "id", id,
                "include", include);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String id;

        private JsonNullable<? extends Include> include = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The include parameter allows you to include additional data in the response.
         */
        public Builder include(Include include) {
            Utils.checkNotNull(include, "include");
            this.include = JsonNullable.of(include);
            return this;
        }

        /**
         * The include parameter allows you to include additional data in the response.
         */
        public Builder include(JsonNullable<? extends Include> include) {
            Utils.checkNotNull(include, "include");
            this.include = include;
            return this;
        }

        public StackoneGetLogRequest build() {

            return new StackoneGetLogRequest(
                id, include);
        }

    }
}
