/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestRequest;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestResponse;
import com.stackone.stackone_client_java.operations.StackoneProxyRequest;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;

/**
 * Routing API requests through StackOne directly to the underlying provider.
 */
public class Proxy {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncProxy asyncSDK;

    Proxy(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncProxy(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncProxy async() {
        return asyncSDK;
    }

    /**
     * Proxy Request
     * 
     * @return The call builder
     */
    public StackoneProxyRequestRequestBuilder proxyRequest() {
        return new StackoneProxyRequestRequestBuilder(sdkConfiguration);
    }

    /**
     * Proxy Request
     * 
     * @param xAccountId The account identifier
     * @param proxyRequestBody 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneProxyRequestResponse proxyRequest(String xAccountId, ProxyRequestBody proxyRequestBody) {
        return proxyRequest(xAccountId, Optional.empty(), proxyRequestBody,
            Optional.empty());
    }

    /**
     * Proxy Request
     * 
     * @param xAccountId The account identifier
     * @param prefer Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     * @param proxyRequestBody 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneProxyRequestResponse proxyRequest(
            String xAccountId, Optional<String> prefer,
            ProxyRequestBody proxyRequestBody, Optional<Options> options) {
        StackoneProxyRequestRequest request =
            StackoneProxyRequestRequest
                .builder()
                .xAccountId(xAccountId)
                .prefer(prefer)
                .proxyRequestBody(proxyRequestBody)
                .build();
        RequestOperation<StackoneProxyRequestRequest, StackoneProxyRequestResponse> operation
              = new StackoneProxyRequest.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
