/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class AuthenticationMetaItem {
    /**
     * The authentication type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<String> type;

    /**
     * The authentication label
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    /**
     * The authentication key
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("key")
    private JsonNullable<String> key;

    /**
     * The required scopes for this authentication method
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("required_scopes")
    private JsonNullable<? extends List<String>> requiredScopes;

    @JsonCreator
    public AuthenticationMetaItem(
            @JsonProperty("type") JsonNullable<String> type,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("key") JsonNullable<String> key,
            @JsonProperty("required_scopes") JsonNullable<? extends List<String>> requiredScopes) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(key, "key");
        Utils.checkNotNull(requiredScopes, "requiredScopes");
        this.type = type;
        this.label = label;
        this.key = key;
        this.requiredScopes = requiredScopes;
    }
    
    public AuthenticationMetaItem() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * The authentication type
     */
    @JsonIgnore
    public JsonNullable<String> type() {
        return type;
    }

    /**
     * The authentication label
     */
    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    /**
     * The authentication key
     */
    @JsonIgnore
    public JsonNullable<String> key() {
        return key;
    }

    /**
     * The required scopes for this authentication method
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> requiredScopes() {
        return (JsonNullable<List<String>>) requiredScopes;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The authentication type
     */
    public AuthenticationMetaItem withType(String type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The authentication type
     */
    public AuthenticationMetaItem withType(JsonNullable<String> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The authentication label
     */
    public AuthenticationMetaItem withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    /**
     * The authentication label
     */
    public AuthenticationMetaItem withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * The authentication key
     */
    public AuthenticationMetaItem withKey(String key) {
        Utils.checkNotNull(key, "key");
        this.key = JsonNullable.of(key);
        return this;
    }

    /**
     * The authentication key
     */
    public AuthenticationMetaItem withKey(JsonNullable<String> key) {
        Utils.checkNotNull(key, "key");
        this.key = key;
        return this;
    }

    /**
     * The required scopes for this authentication method
     */
    public AuthenticationMetaItem withRequiredScopes(List<String> requiredScopes) {
        Utils.checkNotNull(requiredScopes, "requiredScopes");
        this.requiredScopes = JsonNullable.of(requiredScopes);
        return this;
    }

    /**
     * The required scopes for this authentication method
     */
    public AuthenticationMetaItem withRequiredScopes(JsonNullable<? extends List<String>> requiredScopes) {
        Utils.checkNotNull(requiredScopes, "requiredScopes");
        this.requiredScopes = requiredScopes;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMetaItem other = (AuthenticationMetaItem) o;
        return 
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.label, other.label) &&
            Utils.enhancedDeepEquals(this.key, other.key) &&
            Utils.enhancedDeepEquals(this.requiredScopes, other.requiredScopes);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            type, label, key,
            requiredScopes);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AuthenticationMetaItem.class,
                "type", type,
                "label", label,
                "key", key,
                "requiredScopes", requiredScopes);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> type = JsonNullable.undefined();

        private JsonNullable<String> label = JsonNullable.undefined();

        private JsonNullable<String> key = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> requiredScopes = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The authentication type
         */
        public Builder type(String type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The authentication type
         */
        public Builder type(JsonNullable<String> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The authentication label
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        /**
         * The authentication label
         */
        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }


        /**
         * The authentication key
         */
        public Builder key(String key) {
            Utils.checkNotNull(key, "key");
            this.key = JsonNullable.of(key);
            return this;
        }

        /**
         * The authentication key
         */
        public Builder key(JsonNullable<String> key) {
            Utils.checkNotNull(key, "key");
            this.key = key;
            return this;
        }


        /**
         * The required scopes for this authentication method
         */
        public Builder requiredScopes(List<String> requiredScopes) {
            Utils.checkNotNull(requiredScopes, "requiredScopes");
            this.requiredScopes = JsonNullable.of(requiredScopes);
            return this;
        }

        /**
         * The required scopes for this authentication method
         */
        public Builder requiredScopes(JsonNullable<? extends List<String>> requiredScopes) {
            Utils.checkNotNull(requiredScopes, "requiredScopes");
            this.requiredScopes = requiredScopes;
            return this;
        }

        public AuthenticationMetaItem build() {

            return new AuthenticationMetaItem(
                type, label, key,
                requiredScopes);
        }

    }
}
