/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CampaignStatusValue
 * 
 * <p>The Status of the campaign.
 */
public class CampaignStatusValue {

    public static final CampaignStatusValue DRAFT = new CampaignStatusValue("draft");
    public static final CampaignStatusValue ARCHIVED = new CampaignStatusValue("archived");
    public static final CampaignStatusValue LIVE = new CampaignStatusValue("live");
    public static final CampaignStatusValue UNMAPPED_VALUE = new CampaignStatusValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CampaignStatusValue> values = createValuesMap();
    private static final Map<String, CampaignStatusValueEnum> enums = createEnumsMap();

    private final String value;

    private CampaignStatusValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CampaignStatusValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CampaignStatusValue
     */ 
    @JsonCreator
    public static CampaignStatusValue of(String value) {
        synchronized (CampaignStatusValue.class) {
            return values.computeIfAbsent(value, v -> new CampaignStatusValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CampaignStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CampaignStatusValue other = (CampaignStatusValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CampaignStatusValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CampaignStatusValue[] values() {
        synchronized (CampaignStatusValue.class) {
            return values.values().toArray(new CampaignStatusValue[] {});
        }
    }

    private static final Map<String, CampaignStatusValue> createValuesMap() {
        Map<String, CampaignStatusValue> map = new LinkedHashMap<>();
        map.put("draft", DRAFT);
        map.put("archived", ARCHIVED);
        map.put("live", LIVE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CampaignStatusValueEnum> createEnumsMap() {
        Map<String, CampaignStatusValueEnum> map = new HashMap<>();
        map.put("draft", CampaignStatusValueEnum.DRAFT);
        map.put("archived", CampaignStatusValueEnum.ARCHIVED);
        map.put("live", CampaignStatusValueEnum.LIVE);
        map.put("unmapped_value", CampaignStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CampaignStatusValueEnum {

        DRAFT("draft"),
        ARCHIVED("archived"),
        LIVE("live"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CampaignStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

