/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CompletionLearningObjectTypeValue
 * 
 * <p>The StackOne unified learning object type.
 */
public class CompletionLearningObjectTypeValue {

    public static final CompletionLearningObjectTypeValue CONTENT = new CompletionLearningObjectTypeValue("content");
    public static final CompletionLearningObjectTypeValue COURSE = new CompletionLearningObjectTypeValue("course");
    public static final CompletionLearningObjectTypeValue COLLECTION = new CompletionLearningObjectTypeValue("collection");
    public static final CompletionLearningObjectTypeValue UNMAPPED_VALUE = new CompletionLearningObjectTypeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CompletionLearningObjectTypeValue> values = createValuesMap();
    private static final Map<String, CompletionLearningObjectTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private CompletionLearningObjectTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CompletionLearningObjectTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CompletionLearningObjectTypeValue
     */ 
    @JsonCreator
    public static CompletionLearningObjectTypeValue of(String value) {
        synchronized (CompletionLearningObjectTypeValue.class) {
            return values.computeIfAbsent(value, v -> new CompletionLearningObjectTypeValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CompletionLearningObjectTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CompletionLearningObjectTypeValue other = (CompletionLearningObjectTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CompletionLearningObjectTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CompletionLearningObjectTypeValue[] values() {
        synchronized (CompletionLearningObjectTypeValue.class) {
            return values.values().toArray(new CompletionLearningObjectTypeValue[] {});
        }
    }

    private static final Map<String, CompletionLearningObjectTypeValue> createValuesMap() {
        Map<String, CompletionLearningObjectTypeValue> map = new LinkedHashMap<>();
        map.put("content", CONTENT);
        map.put("course", COURSE);
        map.put("collection", COLLECTION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CompletionLearningObjectTypeValueEnum> createEnumsMap() {
        Map<String, CompletionLearningObjectTypeValueEnum> map = new HashMap<>();
        map.put("content", CompletionLearningObjectTypeValueEnum.CONTENT);
        map.put("course", CompletionLearningObjectTypeValueEnum.COURSE);
        map.put("collection", CompletionLearningObjectTypeValueEnum.COLLECTION);
        map.put("unmapped_value", CompletionLearningObjectTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CompletionLearningObjectTypeValueEnum {

        CONTENT("content"),
        COURSE("course"),
        COLLECTION("collection"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CompletionLearningObjectTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

