/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * ConnectSessionType
 * 
 * <p>The connect session account type
 */
public class ConnectSessionType {

    public static final ConnectSessionType PRODUCTION = new ConnectSessionType("production");
    public static final ConnectSessionType TEST = new ConnectSessionType("test");
    public static final ConnectSessionType UNMAPPED_VALUE = new ConnectSessionType("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ConnectSessionType> values = createValuesMap();
    private static final Map<String, ConnectSessionTypeEnum> enums = createEnumsMap();

    private final String value;

    private ConnectSessionType(String value) {
        this.value = value;
    }

    /**
     * Returns a ConnectSessionType with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ConnectSessionType
     */ 
    @JsonCreator
    public static ConnectSessionType of(String value) {
        synchronized (ConnectSessionType.class) {
            return values.computeIfAbsent(value, v -> new ConnectSessionType(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<ConnectSessionTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ConnectSessionType other = (ConnectSessionType) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ConnectSessionType [value=" + value + "]";
    }

    // return an array just like an enum
    public static ConnectSessionType[] values() {
        synchronized (ConnectSessionType.class) {
            return values.values().toArray(new ConnectSessionType[] {});
        }
    }

    private static final Map<String, ConnectSessionType> createValuesMap() {
        Map<String, ConnectSessionType> map = new LinkedHashMap<>();
        map.put("production", PRODUCTION);
        map.put("test", TEST);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ConnectSessionTypeEnum> createEnumsMap() {
        Map<String, ConnectSessionTypeEnum> map = new HashMap<>();
        map.put("production", ConnectSessionTypeEnum.PRODUCTION);
        map.put("test", ConnectSessionTypeEnum.TEST);
        map.put("unmapped_value", ConnectSessionTypeEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum ConnectSessionTypeEnum {

        PRODUCTION("production"),
        TEST("test"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ConnectSessionTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

