/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class EmployeeValue {

    public static final EmployeeValue MALE = new EmployeeValue("male");
    public static final EmployeeValue FEMALE = new EmployeeValue("female");
    public static final EmployeeValue NON_BINARY = new EmployeeValue("non_binary");
    public static final EmployeeValue OTHER = new EmployeeValue("other");
    public static final EmployeeValue NOT_DISCLOSED = new EmployeeValue("not_disclosed");
    public static final EmployeeValue DIVERSE = new EmployeeValue("diverse");
    public static final EmployeeValue UNMAPPED_VALUE = new EmployeeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, EmployeeValue> values = createValuesMap();
    private static final Map<String, EmployeeValueEnum> enums = createEnumsMap();

    private final String value;

    private EmployeeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a EmployeeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as EmployeeValue
     */ 
    @JsonCreator
    public static EmployeeValue of(String value) {
        synchronized (EmployeeValue.class) {
            return values.computeIfAbsent(value, v -> new EmployeeValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<EmployeeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EmployeeValue other = (EmployeeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "EmployeeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static EmployeeValue[] values() {
        synchronized (EmployeeValue.class) {
            return values.values().toArray(new EmployeeValue[] {});
        }
    }

    private static final Map<String, EmployeeValue> createValuesMap() {
        Map<String, EmployeeValue> map = new LinkedHashMap<>();
        map.put("male", MALE);
        map.put("female", FEMALE);
        map.put("non_binary", NON_BINARY);
        map.put("other", OTHER);
        map.put("not_disclosed", NOT_DISCLOSED);
        map.put("diverse", DIVERSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmployeeValueEnum> createEnumsMap() {
        Map<String, EmployeeValueEnum> map = new HashMap<>();
        map.put("male", EmployeeValueEnum.MALE);
        map.put("female", EmployeeValueEnum.FEMALE);
        map.put("non_binary", EmployeeValueEnum.NON_BINARY);
        map.put("other", EmployeeValueEnum.OTHER);
        map.put("not_disclosed", EmployeeValueEnum.NOT_DISCLOSED);
        map.put("diverse", EmployeeValueEnum.DIVERSE);
        map.put("unmapped_value", EmployeeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum EmployeeValueEnum {

        MALE("male"),
        FEMALE("female"),
        NON_BINARY("non_binary"),
        OTHER("other"),
        NOT_DISCLOSED("not_disclosed"),
        DIVERSE("diverse"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private EmployeeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

