/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * Event
 * 
 * <p>The event type
 */
public class Event {

    public static final Event SCREENING_RESULTS_CREATED = new Event("screening.results.created");
    public static final Event SCREENING_RESULTS_UPDATED = new Event("screening.results.updated");
    public static final Event SCREENING_RESULTS_COMPLETED = new Event("screening.results.completed");
    public static final Event SCREENING_RESULTS_FAILED = new Event("screening.results.failed");
    public static final Event SCREENING_RESULTS_CANCELLED = new Event("screening.results.cancelled");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, Event> values = createValuesMap();
    private static final Map<String, EventEnum> enums = createEnumsMap();

    private final String value;

    private Event(String value) {
        this.value = value;
    }

    /**
     * Returns a Event with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as Event
     */ 
    @JsonCreator
    public static Event of(String value) {
        synchronized (Event.class) {
            return values.computeIfAbsent(value, v -> new Event(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<EventEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Event other = (Event) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "Event [value=" + value + "]";
    }

    // return an array just like an enum
    public static Event[] values() {
        synchronized (Event.class) {
            return values.values().toArray(new Event[] {});
        }
    }

    private static final Map<String, Event> createValuesMap() {
        Map<String, Event> map = new LinkedHashMap<>();
        map.put("screening.results.created", SCREENING_RESULTS_CREATED);
        map.put("screening.results.updated", SCREENING_RESULTS_UPDATED);
        map.put("screening.results.completed", SCREENING_RESULTS_COMPLETED);
        map.put("screening.results.failed", SCREENING_RESULTS_FAILED);
        map.put("screening.results.cancelled", SCREENING_RESULTS_CANCELLED);
        return map;
    }

    private static final Map<String, EventEnum> createEnumsMap() {
        Map<String, EventEnum> map = new HashMap<>();
        map.put("screening.results.created", EventEnum.SCREENING_RESULTS_CREATED);
        map.put("screening.results.updated", EventEnum.SCREENING_RESULTS_UPDATED);
        map.put("screening.results.completed", EventEnum.SCREENING_RESULTS_COMPLETED);
        map.put("screening.results.failed", EventEnum.SCREENING_RESULTS_FAILED);
        map.put("screening.results.cancelled", EventEnum.SCREENING_RESULTS_CANCELLED);
        return map;
    }
    
    
    public enum EventEnum {

        SCREENING_RESULTS_CREATED("screening.results.created"),
        SCREENING_RESULTS_UPDATED("screening.results.updated"),
        SCREENING_RESULTS_COMPLETED("screening.results.completed"),
        SCREENING_RESULTS_FAILED("screening.results.failed"),
        SCREENING_RESULTS_CANCELLED("screening.results.cancelled"),;

        private final String value;

        private EventEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

