/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class HRISDivisionValue {

    public static final HRISDivisionValue DEPARTMENT = new HRISDivisionValue("department");
    public static final HRISDivisionValue COMPANY = new HRISDivisionValue("company");
    public static final HRISDivisionValue DIVISION = new HRISDivisionValue("division");
    public static final HRISDivisionValue GROUP = new HRISDivisionValue("group");
    public static final HRISDivisionValue PROJECT = new HRISDivisionValue("project");
    public static final HRISDivisionValue COST_CENTER = new HRISDivisionValue("cost_center");
    public static final HRISDivisionValue TEAM = new HRISDivisionValue("team");
    public static final HRISDivisionValue UNMAPPED_VALUE = new HRISDivisionValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HRISDivisionValue> values = createValuesMap();
    private static final Map<String, HRISDivisionValueEnum> enums = createEnumsMap();

    private final String value;

    private HRISDivisionValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HRISDivisionValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HRISDivisionValue
     */ 
    @JsonCreator
    public static HRISDivisionValue of(String value) {
        synchronized (HRISDivisionValue.class) {
            return values.computeIfAbsent(value, v -> new HRISDivisionValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<HRISDivisionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HRISDivisionValue other = (HRISDivisionValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HRISDivisionValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HRISDivisionValue[] values() {
        synchronized (HRISDivisionValue.class) {
            return values.values().toArray(new HRISDivisionValue[] {});
        }
    }

    private static final Map<String, HRISDivisionValue> createValuesMap() {
        Map<String, HRISDivisionValue> map = new LinkedHashMap<>();
        map.put("department", DEPARTMENT);
        map.put("company", COMPANY);
        map.put("division", DIVISION);
        map.put("group", GROUP);
        map.put("project", PROJECT);
        map.put("cost_center", COST_CENTER);
        map.put("team", TEAM);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISDivisionValueEnum> createEnumsMap() {
        Map<String, HRISDivisionValueEnum> map = new HashMap<>();
        map.put("department", HRISDivisionValueEnum.DEPARTMENT);
        map.put("company", HRISDivisionValueEnum.COMPANY);
        map.put("division", HRISDivisionValueEnum.DIVISION);
        map.put("group", HRISDivisionValueEnum.GROUP);
        map.put("project", HRISDivisionValueEnum.PROJECT);
        map.put("cost_center", HRISDivisionValueEnum.COST_CENTER);
        map.put("team", HRISDivisionValueEnum.TEAM);
        map.put("unmapped_value", HRISDivisionValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum HRISDivisionValueEnum {

        DEPARTMENT("department"),
        COMPANY("company"),
        DIVISION("division"),
        GROUP("group"),
        PROJECT("project"),
        COST_CENTER("cost_center"),
        TEAM("team"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private HRISDivisionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

