/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class IamGroupValue {

    public static final IamGroupValue WORKSPACE = new IamGroupValue("workspace");
    public static final IamGroupValue TEAM = new IamGroupValue("team");
    public static final IamGroupValue DEPARTMENT = new IamGroupValue("department");
    public static final IamGroupValue GROUP = new IamGroupValue("group");
    public static final IamGroupValue ORGANIZATION = new IamGroupValue("organization");
    public static final IamGroupValue UNMAPPED_VALUE = new IamGroupValue("unmapped_value");
    public static final IamGroupValue COST_CENTER = new IamGroupValue("cost_center");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, IamGroupValue> values = createValuesMap();
    private static final Map<String, IamGroupValueEnum> enums = createEnumsMap();

    private final String value;

    private IamGroupValue(String value) {
        this.value = value;
    }

    /**
     * Returns a IamGroupValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as IamGroupValue
     */ 
    @JsonCreator
    public static IamGroupValue of(String value) {
        synchronized (IamGroupValue.class) {
            return values.computeIfAbsent(value, v -> new IamGroupValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<IamGroupValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IamGroupValue other = (IamGroupValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "IamGroupValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static IamGroupValue[] values() {
        synchronized (IamGroupValue.class) {
            return values.values().toArray(new IamGroupValue[] {});
        }
    }

    private static final Map<String, IamGroupValue> createValuesMap() {
        Map<String, IamGroupValue> map = new LinkedHashMap<>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, IamGroupValueEnum> createEnumsMap() {
        Map<String, IamGroupValueEnum> map = new HashMap<>();
        map.put("workspace", IamGroupValueEnum.WORKSPACE);
        map.put("team", IamGroupValueEnum.TEAM);
        map.put("department", IamGroupValueEnum.DEPARTMENT);
        map.put("group", IamGroupValueEnum.GROUP);
        map.put("organization", IamGroupValueEnum.ORGANIZATION);
        map.put("unmapped_value", IamGroupValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", IamGroupValueEnum.COST_CENTER);
        return map;
    }
    
    
    public enum IamGroupValueEnum {

        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center"),;

        private final String value;

        private IamGroupValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

