/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * IamResourceValue
 * 
 * <p>The type of the resource, e.g. user, group, permission, etc.
 */
public class IamResourceValue {

    public static final IamResourceValue PROJECT = new IamResourceValue("project");
    public static final IamResourceValue FILE = new IamResourceValue("file");
    public static final IamResourceValue FOLDER = new IamResourceValue("folder");
    public static final IamResourceValue PRODUCT = new IamResourceValue("product");
    public static final IamResourceValue PROPERTY = new IamResourceValue("property");
    public static final IamResourceValue USER = new IamResourceValue("user");
    public static final IamResourceValue UNMAPPED_VALUE = new IamResourceValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, IamResourceValue> values = createValuesMap();
    private static final Map<String, IamResourceValueEnum> enums = createEnumsMap();

    private final String value;

    private IamResourceValue(String value) {
        this.value = value;
    }

    /**
     * Returns a IamResourceValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as IamResourceValue
     */ 
    @JsonCreator
    public static IamResourceValue of(String value) {
        synchronized (IamResourceValue.class) {
            return values.computeIfAbsent(value, v -> new IamResourceValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<IamResourceValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IamResourceValue other = (IamResourceValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "IamResourceValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static IamResourceValue[] values() {
        synchronized (IamResourceValue.class) {
            return values.values().toArray(new IamResourceValue[] {});
        }
    }

    private static final Map<String, IamResourceValue> createValuesMap() {
        Map<String, IamResourceValue> map = new LinkedHashMap<>();
        map.put("project", PROJECT);
        map.put("file", FILE);
        map.put("folder", FOLDER);
        map.put("product", PRODUCT);
        map.put("property", PROPERTY);
        map.put("user", USER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamResourceValueEnum> createEnumsMap() {
        Map<String, IamResourceValueEnum> map = new HashMap<>();
        map.put("project", IamResourceValueEnum.PROJECT);
        map.put("file", IamResourceValueEnum.FILE);
        map.put("folder", IamResourceValueEnum.FOLDER);
        map.put("product", IamResourceValueEnum.PRODUCT);
        map.put("property", IamResourceValueEnum.PROPERTY);
        map.put("user", IamResourceValueEnum.USER);
        map.put("unmapped_value", IamResourceValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum IamResourceValueEnum {

        PROJECT("project"),
        FILE("file"),
        FOLDER("folder"),
        PRODUCT("product"),
        PROPERTY("property"),
        USER("user"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private IamResourceValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

