/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * JournalLineValue
 * 
 * <p>Type of account
 */
public class JournalLineValue {

    public static final JournalLineValue ASSET = new JournalLineValue("asset");
    public static final JournalLineValue LIABILITY = new JournalLineValue("liability");
    public static final JournalLineValue EQUITY = new JournalLineValue("equity");
    public static final JournalLineValue REVENUE = new JournalLineValue("revenue");
    public static final JournalLineValue EXPENSE = new JournalLineValue("expense");
    public static final JournalLineValue UNMAPPED_VALUE = new JournalLineValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, JournalLineValue> values = createValuesMap();
    private static final Map<String, JournalLineValueEnum> enums = createEnumsMap();

    private final String value;

    private JournalLineValue(String value) {
        this.value = value;
    }

    /**
     * Returns a JournalLineValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as JournalLineValue
     */ 
    @JsonCreator
    public static JournalLineValue of(String value) {
        synchronized (JournalLineValue.class) {
            return values.computeIfAbsent(value, v -> new JournalLineValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<JournalLineValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        JournalLineValue other = (JournalLineValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "JournalLineValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static JournalLineValue[] values() {
        synchronized (JournalLineValue.class) {
            return values.values().toArray(new JournalLineValue[] {});
        }
    }

    private static final Map<String, JournalLineValue> createValuesMap() {
        Map<String, JournalLineValue> map = new LinkedHashMap<>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JournalLineValueEnum> createEnumsMap() {
        Map<String, JournalLineValueEnum> map = new HashMap<>();
        map.put("asset", JournalLineValueEnum.ASSET);
        map.put("liability", JournalLineValueEnum.LIABILITY);
        map.put("equity", JournalLineValueEnum.EQUITY);
        map.put("revenue", JournalLineValueEnum.REVENUE);
        map.put("expense", JournalLineValueEnum.EXPENSE);
        map.put("unmapped_value", JournalLineValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum JournalLineValueEnum {

        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private JournalLineValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

