/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TicketingTicketResultPriority
 * 
 * <p>Priority of the ticket
 */
public class TicketingTicketResultPriority {
    /**
     * The id of the ticket priority.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The priority of the ticket.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TicketingTicketResultValue> value;

    /**
     * The source value of the ticket priority.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TicketingTicketResultSourceValue> sourceValue;

    @JsonCreator
    public TicketingTicketResultPriority(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("value") JsonNullable<? extends TicketingTicketResultValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TicketingTicketResultSourceValue> sourceValue) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.id = id;
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public TicketingTicketResultPriority() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The id of the ticket priority.
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The priority of the ticket.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingTicketResultValue> value() {
        return (JsonNullable<TicketingTicketResultValue>) value;
    }

    /**
     * The source value of the ticket priority.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingTicketResultSourceValue> sourceValue() {
        return (JsonNullable<TicketingTicketResultSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The id of the ticket priority.
     */
    public TicketingTicketResultPriority withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The id of the ticket priority.
     */
    public TicketingTicketResultPriority withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The priority of the ticket.
     */
    public TicketingTicketResultPriority withValue(TicketingTicketResultValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The priority of the ticket.
     */
    public TicketingTicketResultPriority withValue(JsonNullable<? extends TicketingTicketResultValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the ticket priority.
     */
    public TicketingTicketResultPriority withSourceValue(TicketingTicketResultSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the ticket priority.
     */
    public TicketingTicketResultPriority withSourceValue(JsonNullable<? extends TicketingTicketResultSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingTicketResultPriority other = (TicketingTicketResultPriority) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingTicketResultPriority.class,
                "id", id,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<? extends TicketingTicketResultValue> value = JsonNullable.undefined();

        private JsonNullable<? extends TicketingTicketResultSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The id of the ticket priority.
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The id of the ticket priority.
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The priority of the ticket.
         */
        public Builder value(TicketingTicketResultValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The priority of the ticket.
         */
        public Builder value(JsonNullable<? extends TicketingTicketResultValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the ticket priority.
         */
        public Builder sourceValue(TicketingTicketResultSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the ticket priority.
         */
        public Builder sourceValue(JsonNullable<? extends TicketingTicketResultSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public TicketingTicketResultPriority build() {

            return new TicketingTicketResultPriority(
                id, value, sourceValue);
        }

    }
}
