/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class TimeOffValue {

    public static final TimeOffValue APPROVED = new TimeOffValue("approved");
    public static final TimeOffValue CANCELLED = new TimeOffValue("cancelled");
    public static final TimeOffValue REJECTED = new TimeOffValue("rejected");
    public static final TimeOffValue PENDING = new TimeOffValue("pending");
    public static final TimeOffValue DELETED = new TimeOffValue("deleted");
    public static final TimeOffValue DRAFT = new TimeOffValue("draft");
    public static final TimeOffValue UNMAPPED_VALUE = new TimeOffValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TimeOffValue> values = createValuesMap();
    private static final Map<String, TimeOffValueEnum> enums = createEnumsMap();

    private final String value;

    private TimeOffValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TimeOffValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TimeOffValue
     */ 
    @JsonCreator
    public static TimeOffValue of(String value) {
        synchronized (TimeOffValue.class) {
            return values.computeIfAbsent(value, v -> new TimeOffValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TimeOffValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeOffValue other = (TimeOffValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TimeOffValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TimeOffValue[] values() {
        synchronized (TimeOffValue.class) {
            return values.values().toArray(new TimeOffValue[] {});
        }
    }

    private static final Map<String, TimeOffValue> createValuesMap() {
        Map<String, TimeOffValue> map = new LinkedHashMap<>();
        map.put("approved", APPROVED);
        map.put("cancelled", CANCELLED);
        map.put("rejected", REJECTED);
        map.put("pending", PENDING);
        map.put("deleted", DELETED);
        map.put("draft", DRAFT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffValueEnum> createEnumsMap() {
        Map<String, TimeOffValueEnum> map = new HashMap<>();
        map.put("approved", TimeOffValueEnum.APPROVED);
        map.put("cancelled", TimeOffValueEnum.CANCELLED);
        map.put("rejected", TimeOffValueEnum.REJECTED);
        map.put("pending", TimeOffValueEnum.PENDING);
        map.put("deleted", TimeOffValueEnum.DELETED);
        map.put("draft", TimeOffValueEnum.DRAFT);
        map.put("unmapped_value", TimeOffValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TimeOffValueEnum {

        APPROVED("approved"),
        CANCELLED("cancelled"),
        REJECTED("rejected"),
        PENDING("pending"),
        DELETED("deleted"),
        DRAFT("draft"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TimeOffValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

