/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CrmCreateContactRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class CrmUpdateContactRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CrmCreateContactRequestDto crmCreateContactRequestDto;

    @JsonCreator
    public CrmUpdateContactRequest(
            String xAccountId,
            String id,
            Optional<String> prefer,
            CrmCreateContactRequestDto crmCreateContactRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(crmCreateContactRequestDto, "crmCreateContactRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.crmCreateContactRequestDto = crmCreateContactRequestDto;
    }
    
    public CrmUpdateContactRequest(
            String xAccountId,
            String id,
            CrmCreateContactRequestDto crmCreateContactRequestDto) {
        this(xAccountId, id, Optional.empty(),
            crmCreateContactRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public CrmCreateContactRequestDto crmCreateContactRequestDto() {
        return crmCreateContactRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public CrmUpdateContactRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public CrmUpdateContactRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public CrmUpdateContactRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public CrmUpdateContactRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public CrmUpdateContactRequest withCrmCreateContactRequestDto(CrmCreateContactRequestDto crmCreateContactRequestDto) {
        Utils.checkNotNull(crmCreateContactRequestDto, "crmCreateContactRequestDto");
        this.crmCreateContactRequestDto = crmCreateContactRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CrmUpdateContactRequest other = (CrmUpdateContactRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.crmCreateContactRequestDto, other.crmCreateContactRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, prefer,
            crmCreateContactRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CrmUpdateContactRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "prefer", prefer,
                "crmCreateContactRequestDto", crmCreateContactRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private Optional<String> prefer = Optional.empty();

        private CrmCreateContactRequestDto crmCreateContactRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder crmCreateContactRequestDto(CrmCreateContactRequestDto crmCreateContactRequestDto) {
            Utils.checkNotNull(crmCreateContactRequestDto, "crmCreateContactRequestDto");
            this.crmCreateContactRequestDto = crmCreateContactRequestDto;
            return this;
        }

        public CrmUpdateContactRequest build() {

            return new CrmUpdateContactRequest(
                xAccountId, id, prefer,
                crmCreateContactRequestDto);
        }

    }
}
