/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisCreateEmployeeRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class HrisCreateEmployeeRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto;

    @JsonCreator
    public HrisCreateEmployeeRequest(
            String xAccountId,
            Optional<String> prefer,
            HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisCreateEmployeeRequestDto, "hrisCreateEmployeeRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.hrisCreateEmployeeRequestDto = hrisCreateEmployeeRequestDto;
    }
    
    public HrisCreateEmployeeRequest(
            String xAccountId,
            HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
        this(xAccountId, Optional.empty(), hrisCreateEmployeeRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto() {
        return hrisCreateEmployeeRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public HrisCreateEmployeeRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisCreateEmployeeRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisCreateEmployeeRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisCreateEmployeeRequest withHrisCreateEmployeeRequestDto(HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
        Utils.checkNotNull(hrisCreateEmployeeRequestDto, "hrisCreateEmployeeRequestDto");
        this.hrisCreateEmployeeRequestDto = hrisCreateEmployeeRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisCreateEmployeeRequest other = (HrisCreateEmployeeRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.hrisCreateEmployeeRequestDto, other.hrisCreateEmployeeRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, hrisCreateEmployeeRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisCreateEmployeeRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "hrisCreateEmployeeRequestDto", hrisCreateEmployeeRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder hrisCreateEmployeeRequestDto(HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
            Utils.checkNotNull(hrisCreateEmployeeRequestDto, "hrisCreateEmployeeRequestDto");
            this.hrisCreateEmployeeRequestDto = hrisCreateEmployeeRequestDto;
            return this;
        }

        public HrisCreateEmployeeRequest build() {

            return new HrisCreateEmployeeRequest(
                xAccountId, prefer, hrisCreateEmployeeRequestDto);
        }

    }
}
