/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisUpdateEmploymentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class HrisUpdateEmployeeEmploymentRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto;

    @JsonCreator
    public HrisUpdateEmployeeEmploymentRequest(
            String xAccountId,
            String id,
            String subResourceId,
            Optional<String> prefer,
            HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisUpdateEmploymentRequestDto, "hrisUpdateEmploymentRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.prefer = prefer;
        this.hrisUpdateEmploymentRequestDto = hrisUpdateEmploymentRequestDto;
    }
    
    public HrisUpdateEmployeeEmploymentRequest(
            String xAccountId,
            String id,
            String subResourceId,
            HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto) {
        this(xAccountId, id, subResourceId,
            Optional.empty(), hrisUpdateEmploymentRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String subResourceId() {
        return subResourceId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto() {
        return hrisUpdateEmploymentRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public HrisUpdateEmployeeEmploymentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisUpdateEmployeeEmploymentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisUpdateEmployeeEmploymentRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisUpdateEmployeeEmploymentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisUpdateEmployeeEmploymentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisUpdateEmployeeEmploymentRequest withHrisUpdateEmploymentRequestDto(HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto) {
        Utils.checkNotNull(hrisUpdateEmploymentRequestDto, "hrisUpdateEmploymentRequestDto");
        this.hrisUpdateEmploymentRequestDto = hrisUpdateEmploymentRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmployeeEmploymentRequest other = (HrisUpdateEmployeeEmploymentRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.subResourceId, other.subResourceId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.hrisUpdateEmploymentRequestDto, other.hrisUpdateEmploymentRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, subResourceId,
            prefer, hrisUpdateEmploymentRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisUpdateEmployeeEmploymentRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "subResourceId", subResourceId,
                "prefer", prefer,
                "hrisUpdateEmploymentRequestDto", hrisUpdateEmploymentRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private String subResourceId;

        private Optional<String> prefer = Optional.empty();

        private HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder hrisUpdateEmploymentRequestDto(HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto) {
            Utils.checkNotNull(hrisUpdateEmploymentRequestDto, "hrisUpdateEmploymentRequestDto");
            this.hrisUpdateEmploymentRequestDto = hrisUpdateEmploymentRequestDto;
            return this;
        }

        public HrisUpdateEmployeeEmploymentRequest build() {

            return new HrisUpdateEmployeeEmploymentRequest(
                xAccountId, id, subResourceId,
                prefer, hrisUpdateEmploymentRequestDto);
        }

    }
}
