/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisDocumentsUploadRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class HrisUploadEmployeeDocumentRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private HrisDocumentsUploadRequestDto hrisDocumentsUploadRequestDto;

    @JsonCreator
    public HrisUploadEmployeeDocumentRequest(
            String xAccountId,
            String id,
            Optional<String> prefer,
            HrisDocumentsUploadRequestDto hrisDocumentsUploadRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisDocumentsUploadRequestDto, "hrisDocumentsUploadRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.hrisDocumentsUploadRequestDto = hrisDocumentsUploadRequestDto;
    }
    
    public HrisUploadEmployeeDocumentRequest(
            String xAccountId,
            String id,
            HrisDocumentsUploadRequestDto hrisDocumentsUploadRequestDto) {
        this(xAccountId, id, Optional.empty(),
            hrisDocumentsUploadRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public HrisDocumentsUploadRequestDto hrisDocumentsUploadRequestDto() {
        return hrisDocumentsUploadRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public HrisUploadEmployeeDocumentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisUploadEmployeeDocumentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisUploadEmployeeDocumentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisUploadEmployeeDocumentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisUploadEmployeeDocumentRequest withHrisDocumentsUploadRequestDto(HrisDocumentsUploadRequestDto hrisDocumentsUploadRequestDto) {
        Utils.checkNotNull(hrisDocumentsUploadRequestDto, "hrisDocumentsUploadRequestDto");
        this.hrisDocumentsUploadRequestDto = hrisDocumentsUploadRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisUploadEmployeeDocumentRequest other = (HrisUploadEmployeeDocumentRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.hrisDocumentsUploadRequestDto, other.hrisDocumentsUploadRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, prefer,
            hrisDocumentsUploadRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisUploadEmployeeDocumentRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "prefer", prefer,
                "hrisDocumentsUploadRequestDto", hrisDocumentsUploadRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private Optional<String> prefer = Optional.empty();

        private HrisDocumentsUploadRequestDto hrisDocumentsUploadRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder hrisDocumentsUploadRequestDto(HrisDocumentsUploadRequestDto hrisDocumentsUploadRequestDto) {
            Utils.checkNotNull(hrisDocumentsUploadRequestDto, "hrisDocumentsUploadRequestDto");
            this.hrisDocumentsUploadRequestDto = hrisDocumentsUploadRequestDto;
            return this;
        }

        public HrisUploadEmployeeDocumentRequest build() {

            return new HrisUploadEmployeeDocumentRequest(
                xAccountId, id, prefer,
                hrisDocumentsUploadRequestDto);
        }

    }
}
