/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsBatchUpsertContentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class LmsBatchUpsertContentRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto;

    @JsonCreator
    public LmsBatchUpsertContentRequest(
            String xAccountId,
            Optional<String> prefer,
            LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(lmsBatchUpsertContentRequestDto, "lmsBatchUpsertContentRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.lmsBatchUpsertContentRequestDto = lmsBatchUpsertContentRequestDto;
    }
    
    public LmsBatchUpsertContentRequest(
            String xAccountId,
            LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
        this(xAccountId, Optional.empty(), lmsBatchUpsertContentRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto() {
        return lmsBatchUpsertContentRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public LmsBatchUpsertContentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public LmsBatchUpsertContentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public LmsBatchUpsertContentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public LmsBatchUpsertContentRequest withLmsBatchUpsertContentRequestDto(LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
        Utils.checkNotNull(lmsBatchUpsertContentRequestDto, "lmsBatchUpsertContentRequestDto");
        this.lmsBatchUpsertContentRequestDto = lmsBatchUpsertContentRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsBatchUpsertContentRequest other = (LmsBatchUpsertContentRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.lmsBatchUpsertContentRequestDto, other.lmsBatchUpsertContentRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, lmsBatchUpsertContentRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsBatchUpsertContentRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "lmsBatchUpsertContentRequestDto", lmsBatchUpsertContentRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder lmsBatchUpsertContentRequestDto(LmsBatchUpsertContentRequestDto lmsBatchUpsertContentRequestDto) {
            Utils.checkNotNull(lmsBatchUpsertContentRequestDto, "lmsBatchUpsertContentRequestDto");
            this.lmsBatchUpsertContentRequestDto = lmsBatchUpsertContentRequestDto;
            return this;
        }

        public LmsBatchUpsertContentRequest build() {

            return new LmsBatchUpsertContentRequest(
                xAccountId, prefer, lmsBatchUpsertContentRequestDto);
        }

    }
}
