/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessagingDownloadMessagingAttachmentRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;

    /**
     * The format to download the file in
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=format")
    private JsonNullable<String> format;

    /**
     * The export format of the file
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=export_format")
    private JsonNullable<String> exportFormat;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    @JsonCreator
    public MessagingDownloadMessagingAttachmentRequest(
            String xAccountId,
            String id,
            String subResourceId,
            JsonNullable<String> format,
            JsonNullable<String> exportFormat,
            Optional<String> prefer) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(format, "format");
        Utils.checkNotNull(exportFormat, "exportFormat");
        Utils.checkNotNull(prefer, "prefer");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.format = format;
        this.exportFormat = exportFormat;
        this.prefer = prefer;
    }
    
    public MessagingDownloadMessagingAttachmentRequest(
            String xAccountId,
            String id,
            String subResourceId) {
        this(xAccountId, id, subResourceId,
            JsonNullable.undefined(), JsonNullable.undefined(), Optional.empty());
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String subResourceId() {
        return subResourceId;
    }

    /**
     * The format to download the file in
     */
    @JsonIgnore
    public JsonNullable<String> format() {
        return format;
    }

    /**
     * The export format of the file
     */
    @JsonIgnore
    public JsonNullable<String> exportFormat() {
        return exportFormat;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public MessagingDownloadMessagingAttachmentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MessagingDownloadMessagingAttachmentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public MessagingDownloadMessagingAttachmentRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    /**
     * The format to download the file in
     */
    public MessagingDownloadMessagingAttachmentRequest withFormat(String format) {
        Utils.checkNotNull(format, "format");
        this.format = JsonNullable.of(format);
        return this;
    }

    /**
     * The format to download the file in
     */
    public MessagingDownloadMessagingAttachmentRequest withFormat(JsonNullable<String> format) {
        Utils.checkNotNull(format, "format");
        this.format = format;
        return this;
    }

    /**
     * The export format of the file
     */
    public MessagingDownloadMessagingAttachmentRequest withExportFormat(String exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = JsonNullable.of(exportFormat);
        return this;
    }

    /**
     * The export format of the file
     */
    public MessagingDownloadMessagingAttachmentRequest withExportFormat(JsonNullable<String> exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = exportFormat;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MessagingDownloadMessagingAttachmentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MessagingDownloadMessagingAttachmentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingDownloadMessagingAttachmentRequest other = (MessagingDownloadMessagingAttachmentRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.subResourceId, other.subResourceId) &&
            Utils.enhancedDeepEquals(this.format, other.format) &&
            Utils.enhancedDeepEquals(this.exportFormat, other.exportFormat) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, subResourceId,
            format, exportFormat, prefer);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingDownloadMessagingAttachmentRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "subResourceId", subResourceId,
                "format", format,
                "exportFormat", exportFormat,
                "prefer", prefer);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private String subResourceId;

        private JsonNullable<String> format = JsonNullable.undefined();

        private JsonNullable<String> exportFormat = JsonNullable.undefined();

        private Optional<String> prefer = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }


        /**
         * The format to download the file in
         */
        public Builder format(String format) {
            Utils.checkNotNull(format, "format");
            this.format = JsonNullable.of(format);
            return this;
        }

        /**
         * The format to download the file in
         */
        public Builder format(JsonNullable<String> format) {
            Utils.checkNotNull(format, "format");
            this.format = format;
            return this;
        }


        /**
         * The export format of the file
         */
        public Builder exportFormat(String exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = JsonNullable.of(exportFormat);
            return this;
        }

        /**
         * The export format of the file
         */
        public Builder exportFormat(JsonNullable<String> exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = exportFormat;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public MessagingDownloadMessagingAttachmentRequest build() {

            return new MessagingDownloadMessagingAttachmentRequest(
                xAccountId, id, subResourceId,
                format, exportFormat, prefer);
        }

    }
}
