/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class StackoneProxyRequestRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    /**
     * The request body
     */
    @SpeakeasyMetadata("request:mediaType=application/json")
    private ProxyRequestBody proxyRequestBody;

    @JsonCreator
    public StackoneProxyRequestRequest(
            String xAccountId,
            Optional<String> prefer,
            ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.proxyRequestBody = proxyRequestBody;
    }
    
    public StackoneProxyRequestRequest(
            String xAccountId,
            ProxyRequestBody proxyRequestBody) {
        this(xAccountId, Optional.empty(), proxyRequestBody);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    /**
     * The request body
     */
    @JsonIgnore
    public ProxyRequestBody proxyRequestBody() {
        return proxyRequestBody;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public StackoneProxyRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public StackoneProxyRequestRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public StackoneProxyRequestRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    /**
     * The request body
     */
    public StackoneProxyRequestRequest withProxyRequestBody(ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.proxyRequestBody = proxyRequestBody;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneProxyRequestRequest other = (StackoneProxyRequestRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.proxyRequestBody, other.proxyRequestBody);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, proxyRequestBody);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneProxyRequestRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "proxyRequestBody", proxyRequestBody);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private ProxyRequestBody proxyRequestBody;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        /**
         * The request body
         */
        public Builder proxyRequestBody(ProxyRequestBody proxyRequestBody) {
            Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
            this.proxyRequestBody = proxyRequestBody;
            return this;
        }

        public StackoneProxyRequestRequest build() {

            return new StackoneProxyRequestRequest(
                xAccountId, prefer, proxyRequestBody);
        }

    }
}
