/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

// INTERNAL API ONLY

public class Reflections {

    /**
     * Extracts the underlying value from an enum wrapper instance if the class follows the enum wrapper pattern.
     *
     * <p>An enum wrapper is a class that emulates enum behavior but can handle unknown values
     * without runtime errors. This pattern is commonly used for API responses where new
     * enum values might be added over time.
     *
     * <p>The method validates that the class follows the enum wrapper pattern by checking for:
     * <ul>
     *   <li>A static factory method {@code of(String)} or {@code of(Integer)} that returns the class type</li>
     *   <li>An instance method {@code value()} returning String or Integer</li>
     *   <li>At least one public static final field of the same class type (predefined constants)</li>
     * </ul>
     *
     * <p>If all validation passes, the method invokes the {@code value()} method on the provided instance
     * and returns the result.
     *
     * @param clazz    the class to examine for enum wrapper pattern
     * @param instance the instance of the enum wrapper class from which to extract the value
     * @return {@code Optional<?>} containing the extracted value (String or Integer) if the class
     * follows the enum wrapper pattern and the value extraction succeeds, {@code Optional.empty()} otherwise
     */
    public static Optional<?> getUnwrappedEnumValue(Class<?> clazz, Object instance) {
        Objects.requireNonNull(clazz, "Class cannot be null");

        try {
            // Check for factory method of(String) or of(Integer)
            boolean hasFactoryMethod = Arrays.stream(clazz.getDeclaredMethods())
                    .anyMatch(method -> isValidFactoryMethod(method, clazz));
            if (!hasFactoryMethod) {
                return Optional.empty();
            }

            // Check for at least one static constant of same type
            if (!hasStaticConstants(clazz)) {
                return Optional.empty();
            }

            // Check for value() method returning String or Integer
            Method valueMethod = clazz.getMethod("value");
            if (!isValidValueMethod(valueMethod)) {
                return Optional.empty();
            }

            valueMethod.setAccessible(true);
            return Optional.of(valueMethod.invoke(instance));
        } catch (Exception e) {
            return Optional.empty();
        }
    }

    /**
     * Checks if the given class is an enum wrapper.
     *
     * <p>An enum wrapper is a class that emulates enum behavior but can handle unknown values
     * without runtime errors. This pattern is commonly used for API responses where new
     * enum values might be added over time.
     *
     * <p>The method validates that the class follows the enum wrapper pattern by checking for:
     * <ul>
     *   <li>A static factory method {@code of(String)} or {@code of(Integer)} that returns the class type</li>
     *   <li>An instance method {@code value()} returning String or Integer</li>
     *   <li>At least one public static final field of the same class type (predefined constants)</li>
     * </ul>
     *
     * @param clazz the class to examine for enum wrapper pattern
     * @return true if the class is an enum wrapper, false otherwise
     */
    public static boolean isEnumWrapper(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }

        try {
            // Check for factory method of(String) or of(Integer)
            boolean hasFactoryMethod = Arrays.stream(clazz.getDeclaredMethods())
                    .anyMatch(method -> isValidFactoryMethod(method, clazz));
            if (!hasFactoryMethod) {
                return false;
            }

            // Check for at least one static constant of same type
            if (!hasStaticConstants(clazz)) {
                return false;
            }

            // Check for value() method returning String or Integer
            Method valueMethod = clazz.getMethod("value");
            return isValidValueMethod(valueMethod);
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * Checks if the given object is an instance of an enum wrapper class.
     *
     * @param obj the object to check
     * @return true if the object is an instance of an enum wrapper class, false otherwise
     */
    public static boolean isEnumWrapper(Object obj) {
        return obj != null && isEnumWrapper(obj.getClass());
    }

    private static boolean isNumericType(Class<?> type) {
        // Primitive numeric types
        if (type.isPrimitive()) {
            return type == byte.class || type == short.class ||
                    type == int.class || type == long.class ||
                    type == float.class || type == double.class;
        }

        // Number subclasses (Integer, Long, Double, BigDecimal, etc.)
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }

        // Atomic numeric types
        return type == AtomicInteger.class || type == AtomicLong.class;
    }

    /**
     * Checks if the given method is a valid factory method for an enum wrapper.
     *
     * @param method the method to check
     * @param clazz  the class that should be returned by the factory method
     * @return true if valid factory method
     */
    private static boolean isValidFactoryMethod(Method method, Class<?> clazz) {
        // Must be named "of"
        if (!"of".equals(method.getName())) {
            return false;
        }

        // Must be static and return the enum class
        if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(clazz)) {
            return false;
        }

        // Must have exactly one parameter of String or Integer type
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 &&
                (String.class.equals(parameterTypes[0]) || isNumericType(parameterTypes[0]));
    }

    /**
     * Checks if the given method is a valid value() method for an enum wrapper.
     *
     * @param method the value() method to validate
     * @return true if valid value method
     */
    private static boolean isValidValueMethod(Method method) {
        // Must not be static and return String or Integer
        return !Modifier.isStatic(method.getModifiers()) &&
                (String.class.equals(method.getReturnType()) || isNumericType(method.getReturnType()));
    }

    /**
     * Checks if the class has at least one public static final field of the same class type.
     *
     * @param clazz the class to check for static constants
     * @return true if has static constants
     */
    private static boolean hasStaticConstants(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields())
                .anyMatch(field -> {
                    int modifiers = field.getModifiers();
                    return Modifier.isStatic(modifiers) &&
                            Modifier.isFinal(modifiers) &&
                            Modifier.isPublic(modifiers) &&
                            clazz.equals(field.getType());
                });
    }
}
