/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmploymentDepartmentValue {
    public static final EmploymentDepartmentValue WORKSPACE = new EmploymentDepartmentValue("workspace");
    public static final EmploymentDepartmentValue TEAM = new EmploymentDepartmentValue("team");
    public static final EmploymentDepartmentValue DEPARTMENT = new EmploymentDepartmentValue("department");
    public static final EmploymentDepartmentValue GROUP = new EmploymentDepartmentValue("group");
    public static final EmploymentDepartmentValue ORGANIZATION = new EmploymentDepartmentValue("organization");
    public static final EmploymentDepartmentValue UNMAPPED_VALUE = new EmploymentDepartmentValue("unmapped_value");
    public static final EmploymentDepartmentValue COST_CENTER = new EmploymentDepartmentValue("cost_center");
    private static final Map<String, EmploymentDepartmentValue> values = EmploymentDepartmentValue.createValuesMap();
    private static final Map<String, EmploymentDepartmentValueEnum> enums = EmploymentDepartmentValue.createEnumsMap();
    private final String value;

    private EmploymentDepartmentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmploymentDepartmentValue of(String value) {
        Class<EmploymentDepartmentValue> clazz = EmploymentDepartmentValue.class;
        synchronized (EmploymentDepartmentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentDepartmentValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmploymentDepartmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentDepartmentValue other = (EmploymentDepartmentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentDepartmentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentDepartmentValue[] values() {
        Class<EmploymentDepartmentValue> clazz = EmploymentDepartmentValue.class;
        synchronized (EmploymentDepartmentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentDepartmentValue[0]);
        }
    }

    private static final Map<String, EmploymentDepartmentValue> createValuesMap() {
        LinkedHashMap<String, EmploymentDepartmentValue> map = new LinkedHashMap<String, EmploymentDepartmentValue>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, EmploymentDepartmentValueEnum> createEnumsMap() {
        HashMap<String, EmploymentDepartmentValueEnum> map = new HashMap<String, EmploymentDepartmentValueEnum>();
        map.put("workspace", EmploymentDepartmentValueEnum.WORKSPACE);
        map.put("team", EmploymentDepartmentValueEnum.TEAM);
        map.put("department", EmploymentDepartmentValueEnum.DEPARTMENT);
        map.put("group", EmploymentDepartmentValueEnum.GROUP);
        map.put("organization", EmploymentDepartmentValueEnum.ORGANIZATION);
        map.put("unmapped_value", EmploymentDepartmentValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", EmploymentDepartmentValueEnum.COST_CENTER);
        return map;
    }

    public static enum EmploymentDepartmentValueEnum {
        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center");

        private final String value;

        private EmploymentDepartmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

