/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class GuideStepMeta {
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="content")
    private String content;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="list")
    private JsonNullable<? extends List<String>> list;

    @JsonCreator
    public GuideStepMeta(@JsonProperty(value="title") String title, @JsonProperty(value="content") String content, @JsonProperty(value="list") JsonNullable<? extends List<String>> list) {
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(list, "list");
        this.title = title;
        this.content = content;
        this.list = list;
    }

    public GuideStepMeta(String title, String content) {
        this(title, content, (JsonNullable<? extends List<String>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String title() {
        return this.title;
    }

    @JsonIgnore
    public String content() {
        return this.content;
    }

    @JsonIgnore
    public JsonNullable<List<String>> list() {
        return this.list;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GuideStepMeta withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    public GuideStepMeta withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    public GuideStepMeta withList(List<String> list) {
        Utils.checkNotNull(list, "list");
        this.list = JsonNullable.of(list);
        return this;
    }

    public GuideStepMeta withList(JsonNullable<? extends List<String>> list) {
        Utils.checkNotNull(list, "list");
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuideStepMeta other = (GuideStepMeta)o;
        return Utils.enhancedDeepEquals(this.title, other.title) && Utils.enhancedDeepEquals(this.content, other.content) && Utils.enhancedDeepEquals(this.list, other.list);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.title, this.content, this.list);
    }

    public String toString() {
        return Utils.toString(GuideStepMeta.class, "title", this.title, "content", this.content, "list", this.list);
    }

    public static final class Builder {
        private String title;
        private String content;
        private JsonNullable<? extends List<String>> list = JsonNullable.undefined();

        private Builder() {
        }

        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        public Builder list(List<String> list) {
            Utils.checkNotNull(list, "list");
            this.list = JsonNullable.of(list);
            return this;
        }

        public Builder list(JsonNullable<? extends List<String>> list) {
            Utils.checkNotNull(list, "list");
            this.list = list;
            return this;
        }

        public GuideStepMeta build() {
            return new GuideStepMeta(this.title, this.content, this.list);
        }
    }
}

