/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Internal {
    public static final Internal TRUE = new Internal("true");
    public static final Internal FALSE = new Internal("false");
    public static final Internal UNMAPPED_VALUE = new Internal("unmapped_value");
    private static final Map<String, Internal> values = Internal.createValuesMap();
    private static final Map<String, InternalEnum> enums = Internal.createEnumsMap();
    private final String value;

    private Internal(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static Internal of(String value) {
        Class<Internal> clazz = Internal.class;
        synchronized (Internal.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new Internal((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<InternalEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Internal other = (Internal)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "Internal [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Internal[] values() {
        Class<Internal> clazz = Internal.class;
        synchronized (Internal.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new Internal[0]);
        }
    }

    private static final Map<String, Internal> createValuesMap() {
        LinkedHashMap<String, Internal> map = new LinkedHashMap<String, Internal>();
        map.put("true", TRUE);
        map.put("false", FALSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, InternalEnum> createEnumsMap() {
        HashMap<String, InternalEnum> map = new HashMap<String, InternalEnum>();
        map.put("true", InternalEnum.TRUE);
        map.put("false", InternalEnum.FALSE);
        map.put("unmapped_value", InternalEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum InternalEnum {
        TRUE("true"),
        FALSE("false"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private InternalEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

