/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PhoneNumberType {
    public static final PhoneNumberType PERSONAL = new PhoneNumberType("personal");
    public static final PhoneNumberType WORK = new PhoneNumberType("work");
    public static final PhoneNumberType MOBILE = new PhoneNumberType("mobile");
    public static final PhoneNumberType HOME = new PhoneNumberType("home");
    public static final PhoneNumberType UNKNOWN = new PhoneNumberType("unknown");
    public static final PhoneNumberType OTHER = new PhoneNumberType("other");
    public static final PhoneNumberType UNMAPPED_VALUE = new PhoneNumberType("unmapped_value");
    private static final Map<String, PhoneNumberType> values = PhoneNumberType.createValuesMap();
    private static final Map<String, PhoneNumberTypeEnum> enums = PhoneNumberType.createEnumsMap();
    private final String value;

    private PhoneNumberType(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static PhoneNumberType of(String value) {
        Class<PhoneNumberType> clazz = PhoneNumberType.class;
        synchronized (PhoneNumberType.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new PhoneNumberType((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<PhoneNumberTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhoneNumberType other = (PhoneNumberType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "PhoneNumberType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoneNumberType[] values() {
        Class<PhoneNumberType> clazz = PhoneNumberType.class;
        synchronized (PhoneNumberType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new PhoneNumberType[0]);
        }
    }

    private static final Map<String, PhoneNumberType> createValuesMap() {
        LinkedHashMap<String, PhoneNumberType> map = new LinkedHashMap<String, PhoneNumberType>();
        map.put("personal", PERSONAL);
        map.put("work", WORK);
        map.put("mobile", MOBILE);
        map.put("home", HOME);
        map.put("unknown", UNKNOWN);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, PhoneNumberTypeEnum> createEnumsMap() {
        HashMap<String, PhoneNumberTypeEnum> map = new HashMap<String, PhoneNumberTypeEnum>();
        map.put("personal", PhoneNumberTypeEnum.PERSONAL);
        map.put("work", PhoneNumberTypeEnum.WORK);
        map.put("mobile", PhoneNumberTypeEnum.MOBILE);
        map.put("home", PhoneNumberTypeEnum.HOME);
        map.put("unknown", PhoneNumberTypeEnum.UNKNOWN);
        map.put("other", PhoneNumberTypeEnum.OTHER);
        map.put("unmapped_value", PhoneNumberTypeEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum PhoneNumberTypeEnum {
        PERSONAL("personal"),
        WORK("work"),
        MOBILE("mobile"),
        HOME("home"),
        UNKNOWN("unknown"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private PhoneNumberTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

