/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ScreeningResultStatus {
    public static final ScreeningResultStatus PENDING = new ScreeningResultStatus("pending");
    public static final ScreeningResultStatus IN_PROGRESS = new ScreeningResultStatus("in_progress");
    public static final ScreeningResultStatus COMPLETED = new ScreeningResultStatus("completed");
    public static final ScreeningResultStatus FAILED = new ScreeningResultStatus("failed");
    public static final ScreeningResultStatus CANCELLED = new ScreeningResultStatus("cancelled");
    public static final ScreeningResultStatus UNMAPPED_VALUE = new ScreeningResultStatus("unmapped_value");
    private static final Map<String, ScreeningResultStatus> values = ScreeningResultStatus.createValuesMap();
    private static final Map<String, ScreeningResultStatusEnum> enums = ScreeningResultStatus.createEnumsMap();
    private final String value;

    private ScreeningResultStatus(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static ScreeningResultStatus of(String value) {
        Class<ScreeningResultStatus> clazz = ScreeningResultStatus.class;
        synchronized (ScreeningResultStatus.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ScreeningResultStatus((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<ScreeningResultStatusEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScreeningResultStatus other = (ScreeningResultStatus)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ScreeningResultStatus [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScreeningResultStatus[] values() {
        Class<ScreeningResultStatus> clazz = ScreeningResultStatus.class;
        synchronized (ScreeningResultStatus.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ScreeningResultStatus[0]);
        }
    }

    private static final Map<String, ScreeningResultStatus> createValuesMap() {
        LinkedHashMap<String, ScreeningResultStatus> map = new LinkedHashMap<String, ScreeningResultStatus>();
        map.put("pending", PENDING);
        map.put("in_progress", IN_PROGRESS);
        map.put("completed", COMPLETED);
        map.put("failed", FAILED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ScreeningResultStatusEnum> createEnumsMap() {
        HashMap<String, ScreeningResultStatusEnum> map = new HashMap<String, ScreeningResultStatusEnum>();
        map.put("pending", ScreeningResultStatusEnum.PENDING);
        map.put("in_progress", ScreeningResultStatusEnum.IN_PROGRESS);
        map.put("completed", ScreeningResultStatusEnum.COMPLETED);
        map.put("failed", ScreeningResultStatusEnum.FAILED);
        map.put("cancelled", ScreeningResultStatusEnum.CANCELLED);
        map.put("unmapped_value", ScreeningResultStatusEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ScreeningResultStatusEnum {
        PENDING("pending"),
        IN_PROGRESS("in_progress"),
        COMPLETED("completed"),
        FAILED("failed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ScreeningResultStatusEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

