/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Event;
import com.stackone.stackone_client_java.models.components.RawResponse;
import com.stackone.stackone_client_java.models.components.ScreeningResult;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class ScreeningResultWebhook {
    @JsonProperty(value="event")
    private Event event;
    @JsonProperty(value="data")
    private ScreeningResult data;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="raw")
    private JsonNullable<? extends List<RawResponse>> raw;

    @JsonCreator
    public ScreeningResultWebhook(@JsonProperty(value="event") Event event, @JsonProperty(value="data") ScreeningResult data, @JsonProperty(value="raw") JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(event, "event");
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(raw, "raw");
        this.event = event;
        this.data = data;
        this.raw = raw;
    }

    public ScreeningResultWebhook(Event event, ScreeningResult data) {
        this(event, data, (JsonNullable<? extends List<RawResponse>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Event event() {
        return this.event;
    }

    @JsonIgnore
    public ScreeningResult data() {
        return this.data;
    }

    @JsonIgnore
    public JsonNullable<List<RawResponse>> raw() {
        return this.raw;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScreeningResultWebhook withEvent(Event event) {
        Utils.checkNotNull(event, "event");
        this.event = event;
        return this;
    }

    public ScreeningResultWebhook withData(ScreeningResult data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public ScreeningResultWebhook withRaw(List<RawResponse> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    public ScreeningResultWebhook withRaw(JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningResultWebhook other = (ScreeningResultWebhook)o;
        return Utils.enhancedDeepEquals(this.event, other.event) && Utils.enhancedDeepEquals(this.data, other.data) && Utils.enhancedDeepEquals(this.raw, other.raw);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.event, this.data, this.raw);
    }

    public String toString() {
        return Utils.toString(ScreeningResultWebhook.class, "event", this.event, "data", this.data, "raw", this.raw);
    }

    public static final class Builder {
        private Event event;
        private ScreeningResult data;
        private JsonNullable<? extends List<RawResponse>> raw = JsonNullable.undefined();

        private Builder() {
        }

        public Builder event(Event event) {
            Utils.checkNotNull(event, "event");
            this.event = event;
            return this;
        }

        public Builder data(ScreeningResult data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder raw(List<RawResponse> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        public Builder raw(JsonNullable<? extends List<RawResponse>> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public ScreeningResultWebhook build() {
            return new ScreeningResultWebhook(this.event, this.data, this.raw);
        }
    }
}

