/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SkillsLevelValue {
    public static final SkillsLevelValue PRIMARY = new SkillsLevelValue("primary");
    public static final SkillsLevelValue SECONDARY = new SkillsLevelValue("secondary");
    public static final SkillsLevelValue TERTIARY = new SkillsLevelValue("tertiary");
    public static final SkillsLevelValue UNMAPPED_VALUE = new SkillsLevelValue("unmapped_value");
    private static final Map<String, SkillsLevelValue> values = SkillsLevelValue.createValuesMap();
    private static final Map<String, SkillsLevelValueEnum> enums = SkillsLevelValue.createEnumsMap();
    private final String value;

    private SkillsLevelValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static SkillsLevelValue of(String value) {
        Class<SkillsLevelValue> clazz = SkillsLevelValue.class;
        synchronized (SkillsLevelValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new SkillsLevelValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<SkillsLevelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkillsLevelValue other = (SkillsLevelValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "SkillsLevelValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkillsLevelValue[] values() {
        Class<SkillsLevelValue> clazz = SkillsLevelValue.class;
        synchronized (SkillsLevelValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new SkillsLevelValue[0]);
        }
    }

    private static final Map<String, SkillsLevelValue> createValuesMap() {
        LinkedHashMap<String, SkillsLevelValue> map = new LinkedHashMap<String, SkillsLevelValue>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, SkillsLevelValueEnum> createEnumsMap() {
        HashMap<String, SkillsLevelValueEnum> map = new HashMap<String, SkillsLevelValueEnum>();
        map.put("primary", SkillsLevelValueEnum.PRIMARY);
        map.put("secondary", SkillsLevelValueEnum.SECONDARY);
        map.put("tertiary", SkillsLevelValueEnum.TERTIARY);
        map.put("unmapped_value", SkillsLevelValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum SkillsLevelValueEnum {
        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private SkillsLevelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

