/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.errors;

import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Utils;
import jakarta.annotation.Nullable;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public abstract class StackOneError
extends RuntimeException {
    private int code;
    private byte[] body;
    private HttpResponse<?> rawResponse;

    public StackOneError(String message, int code, @Nullable byte[] body, HttpResponse<?> rawResponse, @Nullable Throwable cause) {
        super(message, cause);
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.body = body;
        this.code = code;
        this.rawResponse = rawResponse;
    }

    public Optional<byte[]> body() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> bodyAsString() {
        return this.body().map(x -> new String((byte[])x, StandardCharsets.UTF_8));
    }

    public int code() {
        return this.code;
    }

    public HttpResponse<?> rawResponse() {
        return this.rawResponse;
    }

    public Headers headers() {
        return new Headers(this.rawResponse.headers().map());
    }

    public String message() {
        return this.getMessage();
    }

    public StackOneError withCode(int code) {
        this.code = code;
        return this;
    }

    public StackOneError withBody(@Nullable byte[] body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public StackOneError withRawResponse(HttpResponse<?> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    @Override
    public String toString() {
        return Utils.toString(this.getClass(), "requestMethod", this.rawResponse.request().method(), "requestUri", this.rawResponse.request().uri(), "code", this.code, "responseHeaders", this.rawResponse.headers().map(), "message", this.getMessage(), "body", this.bodyAsString().orElse("null"));
    }
}

