/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateCandidateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsCreateCandidateRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateCandidateRequestDto atsCreateCandidateRequestDto;

    @JsonCreator
    public AtsCreateCandidateRequest(String xAccountId, Optional<String> prefer, AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateCandidateRequestDto, "atsCreateCandidateRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateCandidateRequestDto = atsCreateCandidateRequestDto;
    }

    public AtsCreateCandidateRequest(String xAccountId, AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateCandidateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsCreateCandidateRequestDto atsCreateCandidateRequestDto() {
        return this.atsCreateCandidateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsCreateCandidateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateCandidateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsCreateCandidateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateCandidateRequest withAtsCreateCandidateRequestDto(AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
        Utils.checkNotNull(atsCreateCandidateRequestDto, "atsCreateCandidateRequestDto");
        this.atsCreateCandidateRequestDto = atsCreateCandidateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateCandidateRequest other = (AtsCreateCandidateRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsCreateCandidateRequestDto, other.atsCreateCandidateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.atsCreateCandidateRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateCandidateRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "atsCreateCandidateRequestDto", this.atsCreateCandidateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private AtsCreateCandidateRequestDto atsCreateCandidateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsCreateCandidateRequestDto(AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
            Utils.checkNotNull(atsCreateCandidateRequestDto, "atsCreateCandidateRequestDto");
            this.atsCreateCandidateRequestDto = atsCreateCandidateRequestDto;
            return this;
        }

        public AtsCreateCandidateRequest build() {
            return new AtsCreateCandidateRequest(this.xAccountId, this.prefer, this.atsCreateCandidateRequestDto);
        }
    }
}

