/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsDeleteBackgroundCheckPackageRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    @JsonCreator
    public AtsDeleteBackgroundCheckPackageRequest(String xAccountId, String id, Optional<String> prefer) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
    }

    public AtsDeleteBackgroundCheckPackageRequest(String xAccountId, String id) {
        this(xAccountId, id, Optional.empty());
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsDeleteBackgroundCheckPackageRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsDeleteBackgroundCheckPackageRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsDeleteBackgroundCheckPackageRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsDeleteBackgroundCheckPackageRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsDeleteBackgroundCheckPackageRequest other = (AtsDeleteBackgroundCheckPackageRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer);
    }

    public String toString() {
        return Utils.toString(AtsDeleteBackgroundCheckPackageRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public AtsDeleteBackgroundCheckPackageRequest build() {
            return new AtsDeleteBackgroundCheckPackageRequest(this.xAccountId, this.id, this.prefer);
        }
    }
}

