/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisBatchDocumentUploadRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class HrisBatchUploadEmployeeDocumentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private HrisBatchDocumentUploadRequestDto hrisBatchDocumentUploadRequestDto;

    @JsonCreator
    public HrisBatchUploadEmployeeDocumentRequest(String xAccountId, String id, Optional<String> prefer, HrisBatchDocumentUploadRequestDto hrisBatchDocumentUploadRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisBatchDocumentUploadRequestDto, "hrisBatchDocumentUploadRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.hrisBatchDocumentUploadRequestDto = hrisBatchDocumentUploadRequestDto;
    }

    public HrisBatchUploadEmployeeDocumentRequest(String xAccountId, String id, HrisBatchDocumentUploadRequestDto hrisBatchDocumentUploadRequestDto) {
        this(xAccountId, id, Optional.empty(), hrisBatchDocumentUploadRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public HrisBatchDocumentUploadRequestDto hrisBatchDocumentUploadRequestDto() {
        return this.hrisBatchDocumentUploadRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisBatchUploadEmployeeDocumentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisBatchUploadEmployeeDocumentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisBatchUploadEmployeeDocumentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public HrisBatchUploadEmployeeDocumentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisBatchUploadEmployeeDocumentRequest withHrisBatchDocumentUploadRequestDto(HrisBatchDocumentUploadRequestDto hrisBatchDocumentUploadRequestDto) {
        Utils.checkNotNull(hrisBatchDocumentUploadRequestDto, "hrisBatchDocumentUploadRequestDto");
        this.hrisBatchDocumentUploadRequestDto = hrisBatchDocumentUploadRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisBatchUploadEmployeeDocumentRequest other = (HrisBatchUploadEmployeeDocumentRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.hrisBatchDocumentUploadRequestDto, other.hrisBatchDocumentUploadRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.hrisBatchDocumentUploadRequestDto);
    }

    public String toString() {
        return Utils.toString(HrisBatchUploadEmployeeDocumentRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "hrisBatchDocumentUploadRequestDto", this.hrisBatchDocumentUploadRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private HrisBatchDocumentUploadRequestDto hrisBatchDocumentUploadRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder hrisBatchDocumentUploadRequestDto(HrisBatchDocumentUploadRequestDto hrisBatchDocumentUploadRequestDto) {
            Utils.checkNotNull(hrisBatchDocumentUploadRequestDto, "hrisBatchDocumentUploadRequestDto");
            this.hrisBatchDocumentUploadRequestDto = hrisBatchDocumentUploadRequestDto;
            return this;
        }

        public HrisBatchUploadEmployeeDocumentRequest build() {
            return new HrisBatchUploadEmployeeDocumentRequest(this.xAccountId, this.id, this.prefer, this.hrisBatchDocumentUploadRequestDto);
        }
    }
}

