/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisCreateTimeOffRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class HrisUpdateEmployeeTimeOffRequestRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private HrisCreateTimeOffRequestDto hrisCreateTimeOffRequestDto;

    @JsonCreator
    public HrisUpdateEmployeeTimeOffRequestRequest(String xAccountId, String id, String subResourceId, Optional<String> prefer, HrisCreateTimeOffRequestDto hrisCreateTimeOffRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisCreateTimeOffRequestDto, "hrisCreateTimeOffRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.prefer = prefer;
        this.hrisCreateTimeOffRequestDto = hrisCreateTimeOffRequestDto;
    }

    public HrisUpdateEmployeeTimeOffRequestRequest(String xAccountId, String id, String subResourceId, HrisCreateTimeOffRequestDto hrisCreateTimeOffRequestDto) {
        this(xAccountId, id, subResourceId, Optional.empty(), hrisCreateTimeOffRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String subResourceId() {
        return this.subResourceId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public HrisCreateTimeOffRequestDto hrisCreateTimeOffRequestDto() {
        return this.hrisCreateTimeOffRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisUpdateEmployeeTimeOffRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisUpdateEmployeeTimeOffRequestRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisUpdateEmployeeTimeOffRequestRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    public HrisUpdateEmployeeTimeOffRequestRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public HrisUpdateEmployeeTimeOffRequestRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisUpdateEmployeeTimeOffRequestRequest withHrisCreateTimeOffRequestDto(HrisCreateTimeOffRequestDto hrisCreateTimeOffRequestDto) {
        Utils.checkNotNull(hrisCreateTimeOffRequestDto, "hrisCreateTimeOffRequestDto");
        this.hrisCreateTimeOffRequestDto = hrisCreateTimeOffRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmployeeTimeOffRequestRequest other = (HrisUpdateEmployeeTimeOffRequestRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.subResourceId, other.subResourceId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.hrisCreateTimeOffRequestDto, other.hrisCreateTimeOffRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.subResourceId, this.prefer, this.hrisCreateTimeOffRequestDto);
    }

    public String toString() {
        return Utils.toString(HrisUpdateEmployeeTimeOffRequestRequest.class, "xAccountId", this.xAccountId, "id", this.id, "subResourceId", this.subResourceId, "prefer", this.prefer, "hrisCreateTimeOffRequestDto", this.hrisCreateTimeOffRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private String subResourceId;
        private Optional<String> prefer = Optional.empty();
        private HrisCreateTimeOffRequestDto hrisCreateTimeOffRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder hrisCreateTimeOffRequestDto(HrisCreateTimeOffRequestDto hrisCreateTimeOffRequestDto) {
            Utils.checkNotNull(hrisCreateTimeOffRequestDto, "hrisCreateTimeOffRequestDto");
            this.hrisCreateTimeOffRequestDto = hrisCreateTimeOffRequestDto;
            return this;
        }

        public HrisUpdateEmployeeTimeOffRequestRequest build() {
            return new HrisUpdateEmployeeTimeOffRequestRequest(this.xAccountId, this.id, this.subResourceId, this.prefer, this.hrisCreateTimeOffRequestDto);
        }
    }
}

