/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.IamListGroupsRequest;
import com.stackone.stackone_client_java.models.operations.IamListGroupsResponse;
import com.stackone.stackone_client_java.operations.IamListGroups;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class IamListGroupsRequestBuilder {
    private IamListGroupsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public IamListGroupsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public IamListGroupsRequestBuilder request(IamListGroupsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public IamListGroupsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public IamListGroupsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public IamListGroupsResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListGroups.Sync operation = new IamListGroups.Sync(this.sdkConfiguration, options, this._headers);
        return (IamListGroupsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<IamListGroupsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListGroups.Sync operation = new IamListGroups.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<IamListGroupsRequest, String> iterator = new Paginator<IamListGroupsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), IamListGroupsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<IamListGroupsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

