/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class LmsDeleteUserCompletionRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    @JsonCreator
    public LmsDeleteUserCompletionRequest(String xAccountId, String id, String subResourceId, Optional<String> prefer) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(prefer, "prefer");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.prefer = prefer;
    }

    public LmsDeleteUserCompletionRequest(String xAccountId, String id, String subResourceId) {
        this(xAccountId, id, subResourceId, Optional.empty());
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String subResourceId() {
        return this.subResourceId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsDeleteUserCompletionRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsDeleteUserCompletionRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsDeleteUserCompletionRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    public LmsDeleteUserCompletionRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public LmsDeleteUserCompletionRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsDeleteUserCompletionRequest other = (LmsDeleteUserCompletionRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.subResourceId, other.subResourceId) && Utils.enhancedDeepEquals(this.prefer, other.prefer);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.subResourceId, this.prefer);
    }

    public String toString() {
        return Utils.toString(LmsDeleteUserCompletionRequest.class, "xAccountId", this.xAccountId, "id", this.id, "subResourceId", this.subResourceId, "prefer", this.prefer);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private String subResourceId;
        private Optional<String> prefer = Optional.empty();

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public LmsDeleteUserCompletionRequest build() {
            return new LmsDeleteUserCompletionRequest(this.xAccountId, this.id, this.subResourceId, this.prefer);
        }
    }
}

