/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ActionBuildResponseDto;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StackoneBuildActionEmbeddingsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ActionBuildResponseDto> actionBuildResponseDto;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneBuildActionEmbeddingsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ActionBuildResponseDto> actionBuildResponseDto, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.actionBuildResponseDto = actionBuildResponseDto;
        this.headers = headers;
    }

    public StackoneBuildActionEmbeddingsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ActionBuildResponseDto> actionBuildResponseDto() {
        return this.actionBuildResponseDto;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneBuildActionEmbeddingsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneBuildActionEmbeddingsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneBuildActionEmbeddingsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneBuildActionEmbeddingsResponse withActionBuildResponseDto(ActionBuildResponseDto actionBuildResponseDto) {
        Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
        this.actionBuildResponseDto = Optional.ofNullable(actionBuildResponseDto);
        return this;
    }

    public StackoneBuildActionEmbeddingsResponse withActionBuildResponseDto(Optional<? extends ActionBuildResponseDto> actionBuildResponseDto) {
        Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
        this.actionBuildResponseDto = actionBuildResponseDto;
        return this;
    }

    public StackoneBuildActionEmbeddingsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneBuildActionEmbeddingsResponse other = (StackoneBuildActionEmbeddingsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.actionBuildResponseDto, other.actionBuildResponseDto) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.actionBuildResponseDto, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneBuildActionEmbeddingsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "actionBuildResponseDto", this.actionBuildResponseDto, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ActionBuildResponseDto> actionBuildResponseDto = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder actionBuildResponseDto(ActionBuildResponseDto actionBuildResponseDto) {
            Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
            this.actionBuildResponseDto = Optional.ofNullable(actionBuildResponseDto);
            return this;
        }

        public Builder actionBuildResponseDto(Optional<? extends ActionBuildResponseDto> actionBuildResponseDto) {
            Utils.checkNotNull(actionBuildResponseDto, "actionBuildResponseDto");
            this.actionBuildResponseDto = actionBuildResponseDto;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneBuildActionEmbeddingsResponse build() {
            return new StackoneBuildActionEmbeddingsResponse(this.contentType, this.statusCode, this.rawResponse, this.actionBuildResponseDto, this.headers);
        }
    }
}

