/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetSecurity;
import com.stackone.stackone_client_java.operations.StackoneMcpGet;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneMcpGetRequestBuilder {
    private StackoneMcpGetSecurity security;
    private Optional<String> xAccountId = Optional.empty();
    private Optional<? extends Object> xAccountIdQueryParameter = Optional.empty();
    private String mcpSessionId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public StackoneMcpGetRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneMcpGetRequestBuilder security(StackoneMcpGetSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public StackoneMcpGetRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = Optional.of(xAccountId);
        return this;
    }

    public StackoneMcpGetRequestBuilder xAccountId(Optional<String> xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpGetRequestBuilder xAccountIdQueryParameter(Object xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = Optional.of(xAccountIdQueryParameter);
        return this;
    }

    public StackoneMcpGetRequestBuilder xAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        return this;
    }

    public StackoneMcpGetRequestBuilder mcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    public StackoneMcpGetRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneMcpGetRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private StackoneMcpGetRequest buildRequest() {
        StackoneMcpGetRequest request = new StackoneMcpGetRequest(this.xAccountId, this.xAccountIdQueryParameter, this.mcpSessionId);
        return request;
    }

    public StackoneMcpGetResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneMcpGet.Sync operation = new StackoneMcpGet.Sync(this.sdkConfiguration, this.security, options, this._headers);
        StackoneMcpGetRequest request = this.buildRequest();
        return (StackoneMcpGetResponse)operation.handleResponse(operation.doRequest(request));
    }
}

